/*
 * Decompiled with CFR 0.152.
 */
package com.musigma.producer;

import java.util.Properties;
import kafka.common.FailedToSendMessageException;
import kafka.common.InvalidConfigException;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerClosedException;
import kafka.producer.ProducerConfig;

public class MuProducer {
    private Producer<String, String> producer;

    public MuProducer(Properties props) {
        try {
            ProducerConfig config = new ProducerConfig(props);
            this.producer = new Producer(config);
        }
        catch (NumberFormatException e) {
            System.out.println("Check all producer properties passed");
            e.printStackTrace();
        }
        catch (InvalidConfigException e) {
            System.out.println("Invalid value set for producer properties. Please check all producer properties passed");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            System.out.println("Please check all consumer properties passed");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendMessage(String topicName, String ip, String msg) {
        try {
            KeyedMessage<String, String> data2 = new KeyedMessage<String, String>(topicName, ip, msg);
            this.producer.send(data2);
        }
        catch (FailedToSendMessageException e) {
            System.out.println("Failed to send message after three tries. Check ip address passed and if zookeeper and kafka server are running");
            e.printStackTrace();
        }
        catch (UnknownTopicOrPartitionException e) {
            System.out.println("Unknown topic or partition");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            System.out.println("Please check all parameters passed");
            e.printStackTrace();
        }
        catch (ProducerClosedException e) {
            System.out.println("Producer already closed");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.producer.close();
    }
}

