% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_file.R
\encoding{UTF-8}
\name{create_param_file}
\alias{create_param_file}
\title{Create paramater file for the 'JWSACruncher'}
\usage{
create_param_file(
  dir_file_param,
  bundle = 10000,
  csv_layout = "list",
  csv_separator = ";",
  ndecs = 6,
  policy = "parameters",
  output = NULL,
  matrix_item = getOption("default_matrix_item"),
  tsmatrix_series = getOption("default_tsmatrix_series"),
  paths_path = NULL
)
}
\arguments{
\item{dir_file_param}{Path to the directory that will contains the parameter file "parameters.param".}

\item{bundle}{Maximum size for a group of series (in output). By default \code{bundle = 10000}.}

\item{csv_layout}{Layout of the CSV files (series only). By default \code{csv_layout = "list"}. Other options: \code{csv_layout = "vtable"} (vertical table) or \code{csv_layout = "htable"} (horizontal table).}

\item{csv_separator}{the field separator string used in the CSV file. By default \code{csv_separator = ";"}.}

\item{ndecs}{Number of decimals used in the output. By default \code{ndec = 6}.}

\item{policy}{refreshing policy of the processing. By default \code{policy = "parameters"} (re-estimation of the coefficients of the reg-ARIMA model, see details).}

\item{output}{Full path of the output folder. By default (\code{output = NULL}) a folder is create in the path to the workspace ([workspace]/Output).}

\item{matrix_item}{character containing the items of the matrix output (see the 'JDemetra+' manual for more information). By default, the items defined in the option \code{getOption("default_matrix_item")} are used (option initialized by the default output of the 'JWSACruncher' 2.2.2).}

\item{tsmatrix_series}{character containing the names of the times series to export (see the 'JDemetra+' manual for more information).  By default, the items defined in the option \code{getOption("default_tsmatrix_series")} are used (option initialized by the default output of the 'JWSACruncher' 2.2.2).}

\item{paths_path}{The paths used for relative addresses (see the "Demetra Paths" of the graphical interface of 'JDemetra+').}
}
\value{
Path to the paramater file.
}
\description{
To run the 'JWSACruncher' needs a parameter file and \code{create_param_file} allows to create it.
}
\details{
When the 'JWSACruncher' is launched, the data is refreshed with a specific policy that is defined by the paramater \code{policy}. The available options are:
\itemize{
\item \code{policy = "current"}: all the estimations are fixed;
\item \code{policy = "fixedparameters"} or \code{policy = "fixed"}: re-estimation of the coefficients of the regression variables (but not the ARIMA coefficients);
\item \code{policy = "parameters"} (the default): \code{policy = "fixedparameters"} + re-estimation of ARIMA coefficients;
\item \code{policy = "lastoutliers"}: \code{policy = "parameters"} + re-identification of last outliers (on the last year);
\item \code{policy = "outliers"}: \code{policy = "lastoutliers"} + re-identification of all outliers;
\item \code{policy = "stochastic"}: \code{policy = "outliers"} + re-identification of ARIMA orders;
\item \code{policy = "complete"} or \code{policy = "concurrent"}: the model is completely re-identified and re-estimated.
}
}
\seealso{
\code{\link{cruncher_and_param}}.
}
