% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renv_helpers.R
\name{renv2nix}
\alias{renv2nix}
\title{renv2nix}
\usage{
renv2nix(
  renv_lock_path = "renv.lock",
  project_path,
  return_rix_call = FALSE,
  method = c("fast", "accurate"),
  override_r_ver = NULL,
  ...
)
}
\arguments{
\item{renv_lock_path}{Character, path of the renv.lock file, defaults to
"renv.lock"}

\item{project_path}{Character, where to write \code{default.nix}, for example
"/home/path/to/project". The file will thus be written to the file
"/home/path/to/project/default.nix". If the folder does not exist, it will
be created.}

\item{return_rix_call}{Logical, return the generated rix function call
instead of evaluating it this is for debugging purposes, defaults to
\code{FALSE}}

\item{method}{Character, the method of generating a nix environment from an
renv.lock file. "fast" is an inexact conversion which simply extracts the R
version and a list of all the packages in an renv.lock file and adds them
to the \code{r_pkgs} argument of \code{rix()}. This will use a snapshot of \code{nixpkgs}
that should contain package versions that are not too different from the
ones defined in the \code{renv.lock} file. For packages installed from GitHub or
similar, an attempt is made to handle them and pass them to the \code{git_pkgs}
argument of \code{rix()}. Currently defaults to "fast", "accurate" is not yet
implemented.}

\item{override_r_ver}{Character, defaults to NULL, override the R version
defined in the \code{renv.lock} file with another version. This is especially
useful if the \code{renv.lock} file lists a version of R not (yet) available
through Nix, or if the R version included in the \code{renv.lock} is too old
compared to the package versions. Can also be a date, check
\code{available_dates()}.}

\item{...}{
  Arguments passed on to \code{\link[=rix]{rix}}
  \describe{
    \item{\code{system_pkgs}}{Vector of characters. List further software you wish to
install that are not R packages such as command line applications for
example. You can look for available software on the NixOS website
\url{https://search.nixos.org/packages?channel=unstable&from=0&size=50&sort=relevance&type=packages&query=}}
    \item{\code{local_r_pkgs}}{List. A list of local packages to install. These packages
need to be in the \code{.tar.gz} or \code{.zip} formats and must be in the same
folder as the generated "default.nix" file.}
    \item{\code{tex_pkgs}}{Vector of characters. A set of TeX packages to install. Use
this if you need to compile \code{.tex} documents, or build PDF documents using
Quarto. If you don't know which package to add, start by adding "amsmath".
See the
\code{vignette("d2- installing-system-tools-and-texlive-packages-in-a-nix-environment")}
for more details.}
    \item{\code{py_conf}}{List. A list of two elements, \code{py_version} and \code{py_pkgs}.
\code{py_version} must be of the form \code{"3.12"} for Python 3.12 and \code{py_pkgs}
must be an atomic vector of packages names, for example
\code{py_pkgs = c("polars", "plotnine", "great-tables")}.}
    \item{\code{ide}}{Character, defaults to "none". If you wish to use RStudio to work
interactively use "rstudio" or "rserver" for the server version. Use "code"
for Visual Studio Code or "codium" for Codium, or "positron" for Positron.
You can also use "radian", an interactive REPL. This will install a
project-specific version of the chosen editor which will be differrent than
the one already present in your system (if any). For other editors or if
you want to use an editor already installed on your system (which will
require some configuration to make it work seamlessly with Nix shells see
the \code{vignette("e-configuring-ide")} for configuration examples), use
"none". Please be aware that VS Code and Positron are not free software. To
facilitate their installation, \code{rix()} automatically enables a required
setting without prompting the user for confirmation. See the "Details"
section below for more information.}
    \item{\code{overwrite}}{Logical, defaults to FALSE. If TRUE, overwrite the
\code{default.nix} file in the specified path.}
    \item{\code{print}}{Logical, defaults to FALSE. If TRUE, print \code{default.nix} to
console.}
    \item{\code{message_type}}{Character. Message type, defaults to \code{"simple"}, which
gives minimal but sufficient feedback. Other values are currently
\verb{"quiet}, which generates the files without message, and \code{"verbose"},
displays all the messages.}
    \item{\code{shell_hook}}{Character of length 1, defaults to \code{NULL}. Commands added
to the \code{shellHook} variable are executed when the Nix shell starts. So by
default, using \verb{nix-shell default.nix} will start a specific program,
possibly with flags (separated by space), and/or do shell actions. You can
for example use \code{shell_hook = R}, if you want to directly enter the
declared Nix R session when dropping into the Nix shell.}
  }}
}
\value{
Nothing, this function is called for its side effects only, unless
\code{return_rix_call = TRUE} in which case an unevaluated call to \code{rix()} is
returned
}
\description{
renv2nix
}
\details{
In order for this function to work properly, we recommend not
running it inside the same folder as an existing \code{{renv}} project. Instead,
run it from a new, empty directory which path you pass to \code{project_path},
and use \code{renv_lock_path} to point to the \code{renv.lock} file in the original
\code{{renv}} folder. We recommend that you start from an empty folder to hold
your new Nix project, and copy the \code{renv.lock} file only (not any of the
other files and folders generated by \code{{renv}}) and then call \code{renv2nix()}
there. For more details, see \code{vignette("f-renv2nix")}.
}
\examples{
\dontrun{
# if the lock file is in another folder
renv2nix(
  renv_lock_path = "path/to/original/renv_project/renv.lock",
  project_path = "path/to/rix_project"
)
# you could also copy the renv.lock file in the folder of the Nix
# project (don’t copy any other files generated by `{renv}`)
renv2nix(
  renv_lock_path = "path/to/rix_project/renv.lock",
  project_path = "path/to/rix_project"
)
}

}
