% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_prob_freq.R
\name{comp_prev}
\alias{comp_prev}
\title{Compute the condition's prevalence (baseline probability) from frequencies.}
\usage{
comp_prev(hi = freq$hi, mi = freq$mi, fa = freq$fa, cr = freq$cr)
}
\arguments{
\item{hi}{The number of hits \code{\link{hi}} (or true positives).}

\item{mi}{The number of misses \code{\link{mi}} (or false negatives).}

\item{fa}{The number of false alarms \code{\link{fa}} (or false positives).}

\item{cr}{The number of correct rejections \code{\link{cr}} (or true negatives).}
}
\description{
\code{comp_prev} computes a condition's prevalence value \code{\link{prev}}
(or baseline probability) from 4 essential frequencies
(\code{\link{hi}}, \code{\link{mi}}, \code{\link{fa}}, \code{\link{cr}}).
}
\details{
A condition's prevalence value \code{\link{prev}} is
the probability of the condition being \code{TRUE}.

The probability \code{\link{prev}} can be computed from frequencies
as the the ratio of
\code{\link{cond.true}} (i.e., \code{\link{hi} + \link{mi}})
divided by
\code{\link{N}} (i.e., \code{\link{hi} + \link{mi} + \link{fa} + \link{cr}}):

\code{prev = cond.true/N = (hi + mi)/(hi + mi + fa + cr)}
}
\seealso{
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{is_prob}} verifies probability inputs;
\code{\link{is_freq}} verifies frequency inputs.
}
