% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.predictCox.R
\name{autoplot.predictCox}
\alias{autoplot.predictCox}
\title{Plot predictions from a Cox model}
\usage{
\method{autoplot}{predictCox}(object, type = NULL, ci = FALSE,
  band = FALSE, group.by = "row", reduce.data = FALSE, plot = TRUE,
  digits = 2, alpha = NA, ...)
}
\arguments{
\item{object}{object obtained with the function \code{predictCox}.}

\item{type}{the type of predicted value to display. Choices are 
\code{"hazard"} the hazard function,
\code{"cumhazard"} the cumulative hazard function, 
or \code{"survival"} the survival function.}

\item{ci}{Logical. If \code{TRUE} display the confidence intervals for the predictions.}

\item{band}{Logical. If \code{TRUE} display the confidence bands for the predictions.}

\item{group.by}{The grouping factor used to color the prediction curves. Can be \code{"row"}, \code{"strata"}, or \code{"covariates"}.}

\item{reduce.data}{Logical. If \code{TRUE} only the covariates that does take indentical values for all observations are displayed.}

\item{plot}{Logical. Should the graphic be plotted.}

\item{digits}{integer indicating the number of decimal places}

\item{alpha}{transparency of the confidence bands. Argument passed to \code{ggplot2::geom_ribbon}.}

\item{...}{not used. Only for compatibility with the plot method.}
}
\description{
Plot predictions from a Cox model
}
\examples{
library(survival)
library(ggplot2)

## predictions ##
d <- sampleData(1e2, outcome = "survival")
m.cox <- coxph(Surv(time,event)~ X1 + X2 + X3,
                data = d, x = TRUE, y = TRUE)
dt.basehaz <- predictCox(m.cox)
ggplot(as.data.table(dt.basehaz), aes(x = time, y = survival)) + geom_point() + geom_line()

pred.cox <- predictCox(m.cox, newdata = d[1:4,],
  times = 1:5, type = "survival", keep.newdata = TRUE)
autoplot(pred.cox)
autoplot(pred.cox, group.by = "covariates")
autoplot(pred.cox, group.by = "covariates", reduce.data = TRUE)


m.cox.strata <- coxph(Surv(time,event)~ strata(X1) + strata(X2) + X3 + X6,
data = d, x = TRUE, y = TRUE)
pred.cox.strata <- predictCox(m.cox.strata, newdata = d[1,,drop=FALSE],
time = 1:5, keep.newdata = TRUE)
autoplot(pred.cox.strata, type = "survival")
autoplot(pred.cox.strata, type = "survival", group.by = "strata")
res <- autoplot(pred.cox.strata, type = "survival",
            group.by = "covariates")

# customize display
res$plot + geom_point(data = res$data, size = 5)

## predictions with confidence interval
pred.cox <- predictCox(m.cox, newdata = d[1,,drop=FALSE],
  times = 1:5, type = "survival", se = TRUE, keep.newdata = TRUE)
autoplot(pred.cox, ci = TRUE)

## predictions with confidence bands
pred.cox <- predictCox(m.cox, newdata = d[1,,drop=FALSE],
  times = 1:5, type = "survival", nsim.band = 500,  band = TRUE, keep.newdata = TRUE)
autoplot(pred.cox, band = TRUE)


}
