% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{barplotPortfolioRisk}
\alias{barplotPortfolioRisk}
\title{Create portfolio barplots with the capital allocation and the risk allocation}
\usage{
barplotPortfolioRisk(w, Sigma, type = c("ggplot2", "simple"),
  colors = NULL)
}
\arguments{
\item{w}{Vector or matrix containing the portfolio(s) weights. 
For multiple portfolios, they should be columnwise and named for the legend.}

\item{Sigma}{Covariance matrix of the assets.}

\item{type}{Type of plot. Valid options: \code{"ggplot2", "simple"}. Default is 
\code{"ggplot2"} (the packages \code{ggplot2} and \code{gridExtra} must be installed).}

\item{colors}{Vector of colors for the portfolios (optional).}
}
\description{
Creates a barplot on top with the portfolio capital allocation and another
at the bottom with the risk contribution allocation whose profile is the target of the
risk parity portfolio design with \code{\link{riskParityPortfolio}}.
By default the plot is based on the package \code{ggplot2}, but the user
can also specify a simple base plot.
}
\examples{
library(riskParityPortfolio)

# generate random covariance matrix
set.seed(42)
N <- 10
V <- matrix(rnorm(N^2), nrow = N)
Sigma <- cov(V)

# generate random portfolio vectors
w_single <- runif(N)
w_single <- w_single/sum(w_single)  # normalize
names(w_single) <- LETTERS[1:N]

w_multiple <- matrix(runif(4*N), ncol = 4)
w_multiple <- sweep(w_multiple,  # normalize each column
                    MARGIN = 2, 
                    STATS = colSums(w_multiple), FUN = "/")
rownames(w_multiple) <- LETTERS[1:N]

# plot
barplotPortfolioRisk(w_single, Sigma)
barplotPortfolioRisk(w_multiple, Sigma)
barplotPortfolioRisk(w_multiple, Sigma, colors = viridisLite::viridis(4))
barplotPortfolioRisk(w_multiple, Sigma) + ggplot2::scale_fill_viridis_d()

}
\author{
Daniel P. Palomar and Ze Vinicius
}
