% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-fascicles.R
\name{write_fascicles}
\alias{write_fascicles}
\title{Export fascicles from R}
\usage{
write_fascicles(x, file)
}
\arguments{
\item{x}{An object of class \code{maf_df} storing tractography data.}

\item{file}{Path to a file into which the tractography data should be saved.
Currently supported files are \code{.vtk}, \code{.vtp} and
\href{https://med.inria.fr}{medInria} \code{.fds} file formats.}
}
\value{
The input tractography data (invisibly) so that the function can be
used in pipes.
}
\description{
Export fascicles from R
}
\examples{
uf_left  <- read_fascicles(system.file("extdata", "UF_left.vtp",  package = "riot"))
\dontrun{
out <- fs::file_temp(ext = ".vtp")
write_fascicles(uf_left, file = out)
}
}
