% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomial.R
\name{polynomial}
\alias{polynomial}
\title{Create Polynomials}
\usage{
polynomial(x, degree = 2, center = mean(x, na.rm = TRUE))
}
\arguments{
\item{x}{variable used to create the
polynomials.}

\item{degree}{the maximum degree
polynomial to be returned. Polynomials of degree <= \code{degree} will be
returned.}

\item{center}{the value to center the polynomials at.}
}
\value{
A matrix containing the linear
splines.
}
\description{
Creates polynomial variables, to be used in regression. Will create polynomials of degree less than
or equal to the \code{degree} specified, and will mean center variables by default.
}
\examples{

# Reading in a dataset
data(mri)

# Create a polynomial on ldl
polynomial(mri$ldl, degree=3)

# Use a polynomial in regress
regress("mean", atrophy ~ polynomial(age, degree = 2), data = mri)

}
