% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccardIndex.R
\name{naivePairwiseDist}
\alias{naivePairwiseDist}
\title{Calculate pairwise distances between each pair of items in a list}
\usage{
naivePairwiseDist(list, fun = jaccardIndex)
}
\arguments{
\item{list}{A list}

\item{fun}{A function that receives two vectors (such as jaccardIndex) and
returns a number (scale)}
}
\value{
A symmetric matrix of dimension \code{mxm}, where \code{m} is the
length of the list

This function is inefficient compared with matrix-based methods. It is exported 
just for education and for verifying results of matrix-based methods.
}
\description{
Calculate pairwise distances between each pair of items in a list
}
\examples{

myList <- list(first=LETTERS[3:5], second=LETTERS[1:3], third=LETTERS[1:5], fourth=LETTERS[6:10])
naivePairwiseDist(myList, fun=jaccardIndex)
## despite of the name, any function that returns a number can work
naivePairwiseDist(myList, fun=jaccardDistance)

}
