% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-class.R
\name{rhub_check}
\alias{rhub_check}
\title{An \code{rhub_check} object holds status and results of rhub checks}
\description{
An \code{rhub_check} object holds status and results of rhub checks
}
\section{Usage}{
\preformatted{ch <- rhub_check$new(ids = NULL, status = NULL, group = NULL)
ch$update()
ch$print(...)
ch$browse(which = NULL)
ch$urls(which = NULL)
ch$livelog(which = 1)
ch$cran_summary()
}
}

\section{Arguments}{

\itemize{
\item \code{ch} An rhub check object. It can be created using \code{\link[=check]{check()}},
and other check functions including \code{\link{check_for_cran}}.
See also \code{\link[=last_check]{last_check()}}.
\item \code{ids} Character vector of check ids.
\item \code{status} Check status for \code{ids} or \code{group}.
\item \code{group} Check group id, string scalar. Either \code{group} or \code{ids} must
be non-\code{NULL}.
\item \code{...} Extra arguments are currently ignored.
\item \code{which} Which check to show, if the object contains multiple
checks. For \code{browse} the default is all checks. For \code{livelog} the
default is the first check. A check can be selected via its number
or id.
}
}

\section{Details}{


An \code{rhub_check} object can be created by \code{\link[=check]{check()}}, \code{\link[=list_my_checks]{list_my_checks()}},
or \code{\link[=list_package_checks]{list_package_checks()}}. \code{\link[=last_check]{last_check()}} returns the last check(s)
submitted from the current R session. Do not confuse \code{rhub_check}/\code{rhub_check_for_cran}
(classes) with \code{\link[=check]{check()}} or \code{\link[=check_for_cran]{check_for_cran()}} (functions).

\code{ch$update()} updates the status of the check. Printing the check
status to the screen does not perform an update, unless the status of
the check(s) is unknown.

\code{ch$print()} prints the status of the check(s) to the screen.

\code{ch$cran_summary()} prints text to be copy-pasted in cran-comments.md,
it is especially useful on the output of \code{\link[=check_for_cran]{check_for_cran()}}.

\code{ch$browse()} opens a tab or window in the default web browser, that points
to the detailed logs of the check(s).

\code{ch$urls()} return a \code{\link[tibble:tibble]{tibble::tibble}} with URL to the html log, text log and artifacts
of the check(s).

For both \code{ch$browse()} and \code{ch$urls()}, note that the logs and artifacts
are not kept forever, they are accessible for a few days after submission.

\code{ch$livelog()} shows the live log of the check. The live log can be
interrupted using the usual interruption keyboard shortcut, usually
\code{CTRL+c} or \code{ESC}.
}

