% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-class.R, R/check-list-class.R
\name{rhub_check}
\alias{rhub_check}
\alias{rhub_check_list}
\alias{rhub_check_for_cran}
\title{An \code{rhub_check} object holds status and results of rhub checks}
\description{
An \code{rhub_check} object holds status and results of rhub checks

This class is similar to \link{rhub_check} (it inherites from it),
but it shows the results of the checks in a more consice format
by default. To show the details, call the \code{$details()} method.
}
\section{Usage}{
\preformatted{ch$update()
ch$print(...)
ch$web(which = NULL)
ch$livelog(which = 1)
}

\preformatted{chl$update()
chl$print(...)
chl$details()
chl$livelog(which = 1)
}
}

\section{Arguments}{

\itemize{
\item \code{ch} An rhub check object. It can be created using \code{\link[=check]{check()}},
\code{\link[=list_my_checks]{list_my_checks()}} or \code{\link[=list_package_checks]{list_package_checks()}}.
See also \code{\link[=last_check]{last_check()}}.
\item \code{...} Extra arguments are currently ignored.
\item \code{which} Which check to show, if the object contains multiple
checks. For \code{web} the default is all checks. For \code{livelog} the
default is the first check. A check can be selected via its number
or id.
}
}

\section{Details}{


An \code{rhub_check} object can be created by \code{\link[=check]{check()}}, \code{\link[=list_my_checks]{list_my_checks()}},
or \code{\link[=list_package_checks]{list_package_checks()}}. \code{\link[=last_check]{last_check()}} returns the last check(s)
submitted from the current R session.

\code{ch$update()} updates the status of the check. Printing the check
status to the screen does not perform an update, unless the status of
the check(s) is unknown.

\code{ch$print()} prints the status of the check(s) to the screen.

\code{ch$web()} opens a tab or window in the default web browser, that points
to the detailed logs of the check.

\code{ch$livelog()} shows the live log of the check. The live log can be
interrupted using the usual interruption keyboard shortcut, usually
\code{CTRL+c} or \code{ESC}.



The \code{\link[=list_my_checks]{list_my_checks()}} and \code{\link[=list_package_checks]{list_package_checks()}} functions create
\code{rhub_check_list} objects.

See \link{rhub_check} for the description of the inherited \code{chl$update()},
\code{chl$print()}, \code{chl$livelog()} methods.

\code{chl$details()} prints the details for all checks in the list.
}

\examples{
\dontrun{
check()
ch <- last_check()
ch$update()
ch$web()
ch$livelog()
}
\dontrun{
chl <- list_my_checks()
chl
chl$details()
}
}
