<!-- badges: start -->
![version](https://img.shields.io/github/package-json/v/davidruvolo51/rheroicons?color=%2326709e)
[![R build status](https://github.com/davidruvolo51/rheroicons/workflows/R-CMD-check/badge.svg)](https://github.com/davidruvolo51/rheroicons/actions)
[![CRAN](https://www.r-pkg.org/badges/version/rheroicons)](https://cran.r-project.org/package=rheroicons)
![GitHub package dependency version](https://img.shields.io/github/package-json/dependency-version/davidruvolo51/rheroicons/dev/heroicons)
[![CRAN Monthly Downloads](https://cranlogs.r-pkg.org/badges/rheroicons)](https://cranlogs.r-pkg.org/badges/rheroicons)
[![Lifecycle: stable](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)
  <!-- badges: end -->

# rheroicons

The `rheroicons` packages brings to the [Heroicons](https://github.com/tailwindlabs/heroicons) icon library, developed by [Adam Wathan](https://github.com/adamwathan) and [Steve Schoger](https://github.com/sschoger), as R functions for use in your R-based web projects.

All icons are rendered as inline SVG icons. Therefore, no CSS or JavaScript dependencies are loaded into your Shiny application or other web document at runtime!

## Install

Install the stable version from CRAN.

```r
install.packages("rheroicons")
```

The main branch of this repository and the latest release will always be even with the CRAN release. All development will take place on a new branch, and then merged with main when all tests have passed. New releases may be available prior to CRAN acceptance. If this is the case, you can download the GitHub release using the following command. Please note that release may change if revisions were requested.

```r
remotes::install_github("davidruvolo51/rheroicons@*release")
```

## Getting Started

### Finding Icons

There are over 200 icons in the collection. Each icon has two styles: outline and solid. Icons can be found using the icon gallery.

```r
rheroicons::launch_gallery()
```

Click an icon name to copy the R code used to generate the icon. You can paste the R code directly into your Shiny code or other web-based document.

Alternatively, you can use the `find_icon` function to search for icons.

```r
# returns all icon names
rheroicons::find_icon()

# find icons with `chevron` in the name
rheroicons::find_icons(query = "chevron")

# find icons with `chevron` OR `arrow` in the name
rheroicons::find_icons(query = "chevron|arrow")

# find icons with `down`, `up`, `left`, OR `right` in the name
rheroicons::find_icons(query = "down|up|left|right")

# find icons that end with '_down' using regex
rheroicons::find_icons(query = "(\\_down)$")
```

### Rendering Icons

When you have found the icon that you would like to use, you can render them into your app or web document using the `rheroicon` function.

```r
# rheroicons version of `document-add`
rheroicons::rheroicon(name = "document_add")
```

You can use the [Heroicons](https://heroicons.com) site to find icons. All icons that have a dash (`-`) in the original name were renamed using underscores (`_`). This was done to standardize the CSS classes generated by this package.

#### Arguments

The `rheroicon` function takes the following arguments.

| Argument | Description                         | Options                                        | Default              |
|----------|-------------------------------------|------------------------------------------------|----------------------|
| `name`   | icon name                           | use `find_icon` or `launch_gallery`            | ---                  |
| `type`   | icon style                          | `outline` or `solid`                           | `outline`            |
| `class`  | add your own CSS classes            | ---                                            | `NULL`               |

Example use:

```r
library(shiny)
tags$button(
    id = "copy",
    class = "btn",
    tags$span("Add to clipboard"),
    rheroicons::rheroicon(name = "clipboard_copy")
)
```

### Customizing the appearance of icons

Use the argument `class` to add custom CSS classes to an icon.

```r
library(shiny)

# create a button with the `clipboard_copy` icon
tags$button(
    id = "copy",
    class = "btn",
    tags$span("Add to clipboard"),
    rheroicons::rheroicon(
        name = "clipboard_copy",
        type = "outline", 
        class = "my__ui__icons"
    )
)
```

However, you may find it easier to use the predefined classes generated by this package. All icons have three types of CSS classes.

- global: `rheroicons`
- set: `rheroicons_solid` or `rheroicons_outline`
- icon: `rhericons_*`, where `*` is the name of the icon. (This is same as the icon name.)

The following table displays the CSS classes by set for the `arrow_circle_down` icon.

| Icon Set | Function                                                 | CSS classes                                                  |
|----------|----------------------------------------------------------|--------------------------------------------------------------|
| outline  | `rheroicon(name ="arrow_circle_down", type = "outline")` | `rheroicons rheroicons_outline rheroicons_arrow_circle_down` |
| solid    | `rheroicon(name ="arrow_circle_down", type = "solid")`   | `rheroicons rheroicons_solid rheroicons_arrow_circle_down`   |

You can select and style icons through CSS using these classes. Create a new `tags$style` element and define your styles (or use an external CSS file).

```r
library(shiny)

# ui
ui <- tagList(
  tags$head(
    tags$style(

      # select all instances of rheroicons
      ".rheroicons {
          width: 50px;
          height: 50px;
      }",

      # select all outline icons (set color via the stroke property)
      ".rheroicons_outline {
          stroke: green;
      }",

      # select solid icons (set color via the fill property)
      ".rheroicons_solid {
          fill: red;
      }",

      # select specific icons
      ".rheroicons_home {
          width: 75px;
          height: 75px;
      }",

      # select specific icon of a particular style
      ".rheroicons_outline.rheroicons_home {
          stroke: yellow;
      }"
    )
  )
  # define UI here
  # ...
)
```

### Example

The following code demonstrates how to generate icons in Shiny, render solid and outlined icons, and style icons using CSS.

```r
# pkgs
library(shiny)

# ui
ui <- tagList(
    tags$head(
        tags$style(
            ".rheroicons {
                width: 50px;
                height: 50px;
            }",
            ".rheroicons_arrow_circle_down,
            .rheroicons_arrow_circle_up {
                stroke: blue;
            }",
            ".rheroicons_solid {
                fill: red;
            }"
        )
    ),
    tags$main(
        tags$h2("rheroicons"),
        tags$div(
            rheroicons::rheroicon(name = "arrow_circle_down"),
            rheroicons::rheroicon(name = "arrow_circle_up"),
            rheroicons::rheroicon(name = "arrow_circle_left"),
            rheroicons::rheroicon(name = "arrow_circle_right")
        ),
        tags$div(
            rheroicons::rheroicon(name = "chart_bar", type = "solid"),
            rheroicons::rheroicon(name = "chart_bar")
        ),
        tags$div(
            rheroicons::rheroicon(name = "home", type = "solid"),
            rheroicons::rheroicon(name = "home")
        )
    )
)

# server
server <- function(input, output) { }

# app
shinyApp(ui, server)
```
