% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex-alpha.R
\name{AlphaComplex}
\alias{AlphaComplex}
\title{R6 Class for Alpha Complex}
\description{
AlphaComplex is a simplicial complex constructed from the finite
cells of a Delaunay Triangulation.
}
\details{
The filtration value of each simplex is computed as the square of
the circumradius of the simplex if the circumsphere is empty (the simplex
is then said to be Gabriel), and as the minimum of the filtration values of
the codimension 1 cofaces that make it not Gabriel otherwise. All simplices
that have a filtration value strictly greater than a given alpha squared
value are not inserted into the complex.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
Xl <- seq_circle(10)
Xm <- Reduce(rbind, Xl, init = numeric())
acm <- AlphaComplex$new(points = Xm)
acl <- AlphaComplex$new(points = Xl)
acl
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
ac$get_point(1)
\dontshow{\}) # examplesIf}
}
\seealso{
Other filtrations and reconstructions: 
\code{\link{RipsComplex}},
\code{\link{TangentialComplex}},
\code{\link{WitnessComplex}}
}
\author{
Vincent Rouvreau
}
\concept{filtrations and reconstructions}
\section{Super class}{
\code{rgudhi::PythonClass} -> \code{AlphaComplex}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AlphaComplex-new}{\code{AlphaComplex$new()}}
\item \href{#method-AlphaComplex-create_simplex_tree}{\code{AlphaComplex$create_simplex_tree()}}
\item \href{#method-AlphaComplex-get_point}{\code{AlphaComplex$get_point()}}
\item \href{#method-AlphaComplex-clone}{\code{AlphaComplex$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AlphaComplex-new"></a>}}
\if{latex}{\out{\hypertarget{method-AlphaComplex-new}{}}}
\subsection{Method \code{new()}}{
\code{AlphaComplex} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AlphaComplex$new(points, precision = "safe")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{points}}{Either a \verb{n x d} matrix or a length-\code{n} list of
\code{d}-dimensional vectors or a file with extension \code{.off}.}

\item{\code{precision}}{A string specifying the alpha complex precision. Can be
one of \code{"fast"}, \code{"safe"} or \code{"exact"}. Defaults to \code{"safe"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{AlphaComplex}} object storing the Alpha complex.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AlphaComplex-create_simplex_tree"></a>}}
\if{latex}{\out{\hypertarget{method-AlphaComplex-create_simplex_tree}{}}}
\subsection{Method \code{create_simplex_tree()}}{
Generates a simplex tree from the Delaunay triangulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AlphaComplex$create_simplex_tree(
  max_alpha_square = Inf,
  default_filtration_value = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{max_alpha_square}}{A numeric value specifying the maximum alpha
square threshold the simplices shall not exceed. Default is set to
\code{Inf}, and there is very little point using anything else since it does
not save time.}

\item{\code{default_filtration_value}}{A boolean specifying whether filtration
values should not be computed and will be set to \code{NaN}
(\code{default_filtration_value = TRUE}). Defaults to \code{FALSE} (which means
compute the filtration values).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{SimplexTree}} object storing the computed simplex
tree.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AlphaComplex-get_point"></a>}}
\if{latex}{\out{\hypertarget{method-AlphaComplex-get_point}{}}}
\subsection{Method \code{get_point()}}{
This function returns the point corresponding to a given
vertex from the SimplexTree.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AlphaComplex$get_point(vertex)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vertex}}{An integer value specifying the desired vertex.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector storing the point corresponding to the input
vertex.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AlphaComplex-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AlphaComplex-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AlphaComplex$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
