% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_digraph6.R
\name{as_digraph6}
\alias{as_digraph6}
\alias{as_digraph6.matrix}
\alias{as_digraph6.igraph}
\alias{as_digraph6.network}
\alias{as_digraph6.list}
\alias{as_digraph6.default}
\title{Encode network data as 'digraph6' symbols}
\usage{
as_digraph6(object)

\method{as_digraph6}{matrix}(object)

\method{as_digraph6}{igraph}(object)

\method{as_digraph6}{network}(object)

\method{as_digraph6}{list}(object)

\method{as_digraph6}{default}(object)
}
\arguments{
\item{object}{a matrix, an igraph object or a network object or a list
thereof. See Methods section below.}
}
\value{
A character vector of 'digraph6' symbols.
}
\description{
Generic function encoding directed networks as 'digraph6' symbol(s). See
below for available methods.
}
\details{
The 'digraph6' format is designed for directed graphs. Error is
thrown in case it is given an undirected network.
}
\section{Methods (by class)}{
\itemize{
\item \code{as_digraph6(matrix)}: Expects \code{object} to be a square matrix which is
interpreted as an adjacency matrix of a directed graph.

\item \code{as_digraph6(igraph)}: Igraph \code{object} needs to be a directed graph.
Requires \pkg{igraph} package.

\item \code{as_digraph6(network)}: Network \code{object} needs to be directed network.
Requires \pkg{network} package.

\item \code{as_digraph6(list)}: If \code{object} is a list the function is applied to each
element. Consequently, it can be a list with a mixture of supported objects
classes (adjacency matrices, igraph, or network objects).

\item \code{as_digraph6(default)}: Throws an error about the unhandled class.

}}
\examples{
# From adjacency matrix ----------------------------------------------------
am <- matrix(c(
  0,1,0,
  0,0,1,
  1,0,0),
  byrow=TRUE, ncol=3, nrow=3)
as_digraph6(am)

# From igraph objects ------------------------------------------------------
if(requireNamespace("igraph", quietly=TRUE)) {
  g <- igraph::graph_from_adjacency_matrix(am)
  as_digraph6(g)
}

# From network objects -----------------------------------------------------
if(requireNamespace("network", quietly=TRUE)) {
  net <- network::network(am)
  as_digraph6(net)
}

}
