% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rglobi.R
\name{get_child_taxa}
\alias{get_child_taxa}
\title{Returns all known child taxa with known interaction of specified taxa and rank.}
\usage{
get_child_taxa(taxon.names, rank = "Species", skip = 0, limit = 25,
  opts = list())
}
\arguments{
\item{taxon.names}{list of taxa of which child taxa should be included.}

\item{rank}{selected taxonomic rank of child taxa}

\item{skip}{number of child taxon names to skip before returning result. May be used for pagination.}

\item{limit}{maximum number of child taxon names returned}

\item{opts}{list of options including web service configuration like "port" and "host"}
}
\value{
list of child taxon names
}
\description{
Returns all known child taxa with known interaction of specified taxa and rank.
}
\examples{
\dontrun{
get_child_taxa(list("Aves"))
}
}
\seealso{
Other interactions: \code{\link{get_interaction_matrix}},
  \code{\link{get_interaction_table}},
  \code{\link{get_interaction_types}},
  \code{\link{get_interactions_by_taxa}},
  \code{\link{get_interactions_by_type}},
  \code{\link{get_interactions}},
  \code{\link{get_predators_of}}, \code{\link{get_prey_of}}
}
