% Generated by roxygen2 (4.0.1): do not edit by hand
\name{installations}
\alias{installations}
\title{Installations metadata.}
\usage{
installations(data = "all", uuid = NULL, query = NULL,
  identifier = NULL, identifierType = NULL, limit = 20, start = NULL,
  callopts = list())
}
\arguments{
\item{callopts}{Pass on options to httr::GET for more refined control of
http calls, and error handling}

\item{limit}{Number of records to return}

\item{start}{Record number to start at}

\item{data}{The type of data to get. Default is all data. If not 'all', then one
or more of 'contact', 'endpoint', 'dataset', 'comment', 'deleted', 'nonPublishing'.}

\item{uuid}{UUID of the data node provider. This must be specified if data
is anything other than 'all'.}

\item{query}{Query nodes. Only used when data='all'. Ignored otherwise.}

\item{identifier}{The value for this parameter can be a simple string or integer,
e.g. identifier=120. This parameter doesn't seem to be useful right now.}

\item{identifierType}{Used in combination with the identifier parameter to filter
   identifiers by identifier type. See details. This parameter doesn't seem to
   be useful right now.}
}
\value{
A list.
}
\description{
Installations metadata.
}
\details{
identifierType options:

\itemize{
 \item {DOI} No description.
 \item {FTP} No description.
 \item {GBIF_NODE} Identifies the node (e.g: 'DK' for Denmark, 'sp2000' for Species 2000).
 \item {GBIF_PARTICIPANT} Participant identifier from the GBIF IMS Filemaker system.
 \item {GBIF_PORTAL} Indicates the identifier originated from an auto_increment column in the
 portal.data_provider or portal.data_resource table respectively.
 \item {HANDLER} No description.
 \item {LSID} Reference controlled by a separate system, used for example by DOI.
 \item {SOURCE_ID} No description.
 \item {UNKNOWN} No description.
 \item {URI} No description.
 \item {URL} No description.
 \item {UUID} No description.
}
}
\examples{
\dontrun{
installations()
installations(query="france")
installations(uuid="b77901f9-d9b0-47fa-94e0-dd96450aa2b4")
installations(data='contact', uuid="b77901f9-d9b0-47fa-94e0-dd96450aa2b4")
installations(data='contact', uuid="2e029a0c-87af-42e6-87d7-f38a50b78201")
installations(data='endpoint', uuid="b77901f9-d9b0-47fa-94e0-dd96450aa2b4")
installations(data='dataset', uuid="b77901f9-d9b0-47fa-94e0-dd96450aa2b4")
installations(data='deleted')
installations(data='deleted', limit2=2)
installations(data=c('deleted','nonPublishing'), limit=2)
installations(identifierType='DOI', limit=2)
}
}
\references{
\url{http://www.gbif.org/developer/summary}
}

