% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rf.crossValidation}
\alias{rf.crossValidation}
\title{Random Forest Classification Model Cross-validation}
\usage{
rf.crossValidation(x, xdata, p = 0.1, n = 99, seed = NULL, plot = TRUE,
  ...)
}
\arguments{
\item{x}{random forest object}

\item{xdata}{x data used in model}

\item{p}{Percent data withold}

\item{n}{Number of cross validations}

\item{seed}{Sets random seed in R global environment}

\item{plot}{plot crossvalidation error statitistic (TRUE/FALSE)}

\item{...}{Additional arguments passed to Random Forests}
}
\value{
A list class object with the following components:

cv.Summary - Dataframe with summary statistics for error, pcc and ob

Error.distribution - Vector of error values for each cv

PCC.distribution - Vector of pcc values for each cv

OOB.distribution - Vector of oob values for each cv
}
\description{
Implements an n-Fold Cross-validation for Random Forests classification models
}
\note{
The crossvalidation statistics are based on the prediction error on the witheld data:
percent correctly classified (PCC) and out-of-bag model error.
The plot y axis represents the probability density function (see ?density)
}
\examples{
require(randomForest)
  data(iris)
    iris$Species <- as.factor(iris$Species)
      set.seed(1234)
( rf.mdl <- randomForest(iris[,1:4], iris[,"Species"], ntree=501) )
  ( rf.cv <- rf.crossValidation(rf.mdl, iris[,1:4], p=0.10, n=99, ntree=501) )
}
\author{
Jeffrey S. Evans    <jeffrey_evans<at>tnc.org>
}
\references{
Evans, J.S. and S.A. Cushman (2009) Gradient Modeling of Conifer Species Using Random Forest. Landscape Ecology 5:673-683.

Murphy M.A., J.S. Evans, and A.S. Storfer (2010) Quantify Bufo boreas connectivity in Yellowstone National Park with landscape genetics. Ecology 91:252-261

Evans J.S., M.A. Murphy, Z.A. Holden, S.A. Cushman (2011). Modeling species distribution and change using Random Forests CH.8 in Predictive Modeling in Landscape Ecology eds Drew, CA, Huettmann F, Wiersma Y. Springer
}

