\name{aggregate_tasks}
\alias{aggregate_tasks}
\title{Combine (potentially overlapping) article sets generated by screening among a team of reviewers.}
\description{A common task in systematic review is to divide a dataset of articles located by a search (typically involving >1 databases) and distributing them amongst a team of reviewers for screening. This function takes a dataset divided using \code{link{distribute_tasks}} and recombines them into a single \code{data.frame}.}
\usage{
aggregate_tasks(file_names, match_column, selection_column, reviewer_names)
}
\arguments{
  \item{file_names}{a vector or list of file paths used to locate screened files. Must be in .csv format.}
  \item{match_column}{The name of the column used to match identical references. In revtools this is 'label', which is the default here.}
  \item{selection_column}{The name of the column used to store 'selection' data; i.e. which entries have been retained and which excluded. In revtools this is 'selected', which is the default here.}
  \item{reviewer_names}{Optional vector of names used to label the 'results' columns in the resulting \code{data.frame}.}
}
\value{
Returns a data.frame with one row per unique value of \code{match_column}, showing the content of \code{selection_column} for each reviewer.
}
\seealso{
	\code{\link{distribute_tasks}} for the inverse problem of dividing a single dataset amongst many reviewers.
}