/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;
import org.chocosolver.util.tools.MathUtils;

public class PropScale
extends Propagator<IntVar> {
    protected static final int MAX = 0x7FFFFFFE;
    protected static final int MIN = -2147483647;
    private final IntVar X;
    private final IntVar Z;
    private final int Y;
    private final boolean enumerated;
    private final IntIterableBitSet values;

    public PropScale(IntVar x, int y, IntVar z) {
        super((Variable[])new IntVar[]{x, z}, (Priority)PropagatorPriority.BINARY, false);
        this.X = ((IntVar[])this.vars)[0];
        this.Z = ((IntVar[])this.vars)[1];
        this.Y = y;
        assert (y > 1);
        this.enumerated = this.X.hasEnumeratedDomain() && this.Z.hasEnumeratedDomain();
        this.values = this.enumerated ? new IntIterableBitSet() : null;
    }

    @Override
    public final void propagate(int evtmask) throws ContradictionException {
        this.X.updateBounds(MathUtils.divCeil(this.Z.getLB(), this.Y), MathUtils.divFloor(this.Z.getUB(), this.Y), this);
        boolean hasChanged = this.Z.updateBounds(this.X.getLB() * this.Y, this.X.getUB() * this.Y, this);
        if (this.enumerated) {
            int ub = this.X.getUB();
            int v = this.X.getLB();
            while (v <= ub) {
                if (!this.Z.contains(v * this.Y)) {
                    this.X.removeValue(v, this);
                }
                v = this.X.nextValue(v);
            }
            v = this.Z.getLB();
            this.values.clear();
            this.values.setOffset(v);
            ub = this.Z.getUB();
            while (v <= ub) {
                if (v / this.Y * this.Y != v || !this.X.contains(v / this.Y)) {
                    this.values.add(v);
                }
                v = this.Z.nextValue(v);
            }
            this.Z.removeValues(this.values, this);
        } else if (hasChanged && this.Z.hasEnumeratedDomain() && (this.Z.getLB() > this.X.getLB() * this.Y || this.Z.getUB() < this.X.getUB() * this.Y)) {
            this.propagate(evtmask);
        }
    }

    @Override
    public final ESat isEntailed() {
        if (this.X.getUB() * this.Y < this.Z.getLB() || this.X.getLB() * this.Y > this.Z.getUB()) {
            return ESat.FALSE;
        }
        if (this.X.isInstantiated() && this.Z.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

