% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDSFileResourceClient.R
\docType{class}
\name{RDSFileResourceClient}
\alias{RDSFileResourceClient}
\title{R object file resource client}
\format{
A R6 object of class RDSFileResourceClient
}
\description{
R object file resource client

R object file resource client
}
\details{
Connects to a RDS file and loads the serialized object. Similar to the R data file resource,
except that the RDS format stores a single R object.
}
\section{Super classes}{
\code{\link[resourcer:ResourceClient]{resourcer::ResourceClient}} -> \code{\link[resourcer:FileResourceClient]{resourcer::FileResourceClient}} -> \code{RDSFileResourceClient}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{RDSFileResourceClient$new()}}
\item \href{#method-asDataFrame}{\code{RDSFileResourceClient$asDataFrame()}}
\item \href{#method-getValue}{\code{RDSFileResourceClient$getValue()}}
\item \href{#method-clone}{\code{RDSFileResourceClient$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="resourcer" data-topic="ResourceClient" data-id="asTbl">}\href{../../resourcer/html/ResourceClient.html#method-asTbl}{\code{resourcer::ResourceClient$asTbl()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="resourcer" data-topic="ResourceClient" data-id="exec">}\href{../../resourcer/html/ResourceClient.html#method-exec}{\code{resourcer::ResourceClient$exec()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="resourcer" data-topic="ResourceClient" data-id="getConnection">}\href{../../resourcer/html/ResourceClient.html#method-getConnection}{\code{resourcer::ResourceClient$getConnection()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="resourcer" data-topic="ResourceClient" data-id="getResource">}\href{../../resourcer/html/ResourceClient.html#method-getResource}{\code{resourcer::ResourceClient$getResource()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="resourcer" data-topic="FileResourceClient" data-id="close">}\href{../../resourcer/html/FileResourceClient.html#method-close}{\code{resourcer::FileResourceClient$close()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="resourcer" data-topic="FileResourceClient" data-id="downloadFile">}\href{../../resourcer/html/FileResourceClient.html#method-downloadFile}{\code{resourcer::FileResourceClient$downloadFile()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new RDSFileResourceClient instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RDSFileResourceClient$new(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{A valid resource object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A RDSFileResourceClient object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-asDataFrame"></a>}}
\if{latex}{\out{\hypertarget{method-asDataFrame}{}}}
\subsection{Method \code{asDataFrame()}}{
Coerce the resource value extracted from the R object file to a data.frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RDSFileResourceClient$asDataFrame(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional parameters to as.data.frame (not used yet).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data.frame.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getValue"></a>}}
\if{latex}{\out{\hypertarget{method-getValue}{}}}
\subsection{Method \code{getValue()}}{
Get the resource value extracted from the R object file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RDSFileResourceClient$getValue()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The resource value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RDSFileResourceClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
