% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_blended.R
\name{dist_blended}
\alias{dist_blended}
\title{Blended distribution}
\usage{
dist_blended(dists, probs = NULL, breaks = NULL, bandwidths = NULL)
}
\arguments{
\item{dists}{A list of k >= 2 component Distributions.}

\item{probs}{k Mixture weight parameters}

\item{breaks}{k - 1 Centers of the blending zones.
\code{dists[i]} will blend into \code{dists[i + 1]} around \code{breaks[i]}.}

\item{bandwidths}{k - 1 Radii of the blending zones.
The i-th blending zone will begin at \code{breaks[i] - bandwidths[i]} and end at
\code{breaks[i] + bandwidths[i]}. A bandwidth of 0 corresponds to a hard cut-off,
i.e. a jump discontinuity in the density of the blended Distribution.}
}
\value{
A \code{BlendedDistribution} object.
}
\description{
Blended distribution
}
\examples{
bd <- dist_blended(
  list(
    dist_normal(mean = 0.0, sd = 1.0),
    dist_genpareto(u = 3.0, sigmau = 1.0, xi = 3.0)
  ),
  breaks = list(3.0),
  bandwidths = list(0.5),
  probs = list(0.9, 0.1)
)

plot_distributions(
  bd,
  .x = seq(-3, 10, length.out = 100),
  plots = c("d", "p")
)

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_bdegp}()},
\code{\link{dist_beta}()},
\code{\link{dist_binomial}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_mixture}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
