% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_util.R
\name{k_matrix}
\alias{k_matrix}
\title{Cast to a TensorFlow matrix}
\usage{
k_matrix(x, dtype = NULL)
}
\arguments{
\item{x}{Numeric object to be converted to a matrix Tensor.}

\item{dtype}{Type of the elements of the resulting tensor. Defaults to \code{\link[=k_floatx]{k_floatx()}}.}
}
\value{
A two-dimensional \code{tf.Tensor} with values from \code{x}.
The shape will be \verb{(nrow(x), ncol(x))} where \code{x} is first converted to an R matrix via \code{\link[=as.matrix]{as.matrix()}}.
}
\description{
Cast to a TensorFlow matrix
}
\examples{
if (keras::is_keras_available()) {
  k_matrix(diag(1:3))
  k_matrix(diag(1:3), dtype = "int32")
  # Vectors are converted to columns:
  k_matrix(1:3)
}

}
