% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sry_yield.R
\name{yield}
\alias{yield}
\title{Storage-Reliability-Yield (SRY) relationships: Yield computation}
\usage{
yield(Q, capacity, reliability, demand_profile, plot = TRUE, S_initial = 1,
  max_iterations = 50, double_cycle = FALSE)
}
\arguments{
\item{Q}{vector or time series object. Net inflow totals to the reservoir.}

\item{capacity}{numerical. The reservoir storage capacity. Must be in the same volumetric units as Q.}

\item{reliability}{numerical. The required time-based reliability.}

\item{demand_profile}{a vector of factors with length = frequency(Q). Represents within-year demand profile. Defaults to constant release if left blank.}

\item{plot}{logical. If TRUE (the default) the storage behavior diagram and release time series are plotted.}

\item{S_initial}{numeric. The initial storage as a ratio of capacity (0 <= S_initial <= 1). The default value is 1.}

\item{max_iterations}{Maximum number of iterations for yield computation.}

\item{double_cycle}{logical. If TRUE the input series will be replicated and placed end-to-end to double the simulation. (Recommended if the critical period occurs at the end of the recorded inflow time series)}
}
\value{
Returns yield of a reservoir with specified storage capacity and time-based reliability.
}
\description{
Returns the yield for given inflow time series, reservoir capacity, and required time-based reliability. Assumes standard operating policy. Yield is computed iteratively using the bi-section method.
}
\examples{
# Compute yield for 0.95 reliability
layout(1:3)
yield_ResX <- yield(resX$Q_Mm3, capacity = 500, reliability = 0.95)
# Compute yield for quarterly time series with seasonal demand profile

quart_ts <- aggregate(resX$Q_Mm3, nfrequency = 4)
yld <- yield(quart_ts,
capacity = 500, reliability = 0.9, demand_profile = c(0.8, 1.2, 1.2, 0.8))
}

