% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fopls}
\alias{fopls}
\title{fast orthogonal scores algorithn of partial leat squares (opls)}
\usage{
fopls(X, Y, ncomp, scale, 
      maxiter, tol)
}
\arguments{
\item{X}{a \code{matrix} of predictor variables.}

\item{Y}{a \code{matrix} of either a single or multiple response variables.}

\item{ncomp}{the number of pls components.}

\item{scale}{logical indicating whether \code{X} must be scaled.}

\item{maxiter}{maximum number of iterations.}

\item{tol}{limit for convergence of the algorithm in the nipals algorithm.}
}
\value{
a list containing the following elements:
\itemize{
\item{\code{coefficients}}{ the \code{matrix} of regression coefficients.}
\item{\code{bo}}{ a \code{matrix} of one row containing the intercepts for each component.}
\item{\code{transf}}{ a \code{list} conating two objects: \code{Xcenter} and \code{Xscale}}. 
}
}
\description{
Computes orthogonal socres partial least squares (opls) regressions with the NIPALS algorithm. It allows multiple response variables. 
In contrast to code{opls} function, this one does not compute unnecessary data for local regressions.
For internal use only!
}
\author{
Leonardo Ramirez-Lopez
}
\keyword{internal}

