% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.R
\name{bootstrapImputation}
\alias{bootstrapImputation}
\title{Bootstrap Imputation}
\usage{
bootstrapImputation(
  expression_matrix,
  select_cells = NULL,
  select_genes = NULL,
  log_transformed = TRUE,
  log_base = exp(1),
  proportion_genes = 0.6,
  bootstrap_samples = 100,
  number_pcs = 8,
  k_neighbors = 30,
  snn_resolution = 0.9,
  impute_index = NULL,
  use_mclapply = FALSE,
  cores = 2,
  return_individual_results = FALSE,
  python_path = NULL,
  verbose = FALSE
)
}
\arguments{
\item{expression_matrix}{Row by column log-normalized expression matrix}

\item{select_cells}{Subset cells if desired}

\item{select_genes}{A vector of highly variable of differentially expressed gene names,
defaults to the most variable}

\item{log_transformed}{Whether the expression matrix has been log-transformed}

\item{log_base}{If log-transformed, log-base used}

\item{proportion_genes}{Proportion of informative genes to sample}

\item{bootstrap_samples}{Number of samples for the bootstrap}

\item{number_pcs}{Number of dimensions to inform SNN clustering}

\item{k_neighbors}{Number of k neighbors to use for NN network}

\item{snn_resolution}{Resolution parameter for SNN}

\item{impute_index}{Index to impute, will default to all zeroes}

\item{use_mclapply}{Run in parallel, default FALSE}

\item{cores}{Number of cores for parallelization}

\item{return_individual_results}{Return a list of subsampled means}

\item{python_path}{path to your python binary (default = system path)}

\item{verbose}{Print progress output to the console}
}
\value{
Returns a list with the imputed and original expression matrices
}
\description{
Subsample informative genes, cluster cells using SNN, estimate missing expression
values with the distribution mean of means extrapolated from these cell clusterings
}
\examples{
set.seed(0)
requireNamespace("Matrix")

## generate (meaningless) counts
c1 <- stats::rpois(5e3, 1)
c2 <- stats::rpois(5e3, 2)
m <- t(
  rbind(
    matrix(c1, nrow = 20),
    matrix(c2, nrow = 20)
  )
)

## construct an expression matrix m
colnames(m) <- paste0('cell', 1:ncol(m))
rownames(m) <- paste0('gene', 1:nrow(m))
m <- log(m/colSums(m)*1e4 + 1)
m <- methods::as(m, 'dgCMatrix')

## impute
\donttest{
m_imputed <- rescue::bootstrapImputation(
  expression_matrix = m,
  proportion_genes = .9,
  bootstrap_samples = 2,
  k_neighbors = 10
)
}

}
