% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandMat.R
\name{makeAB}
\alias{makeAB}
\title{Create rotation matrix used to determine linear combination of mtry features.}
\usage{
makeAB(p, d, sparsity, ...)
}
\arguments{
\item{p}{the number of dimensions.}

\item{d}{the number of desired columns in the projection matrix.}

\item{sparsity}{a real number in \eqn{(0,1)} that specifies the distribution of non-zero elements in the random matrix.}

\item{...}{used to handle superfluous arguments passed in using paramList.}
}
\value{
rotationMatrix the matrix used to determine which mtry features or combination of features will be used to split a node.
}
\description{
This function is the default option to make the projection matrix for
unsupervised random forest. The sparseM matrix is the projection
matrix.  The creation of this matrix can be changed, but the nrow of
sparseM should remain p.  The ncol of the sparseM matrix is currently
set to mtry but this can actually be any integer > 1; can even be
greater than p.  The matrix returned by this function creates a
sparse matrix with multiple features per column.
}
