% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandMat.R
\name{RandMatPoisson}
\alias{RandMatPoisson}
\title{Create a Random Matrix: Poisson}
\usage{
RandMatPoisson(p, d, lambda, catMap = NULL, ...)
}
\arguments{
\item{p}{the number of dimensions.}

\item{d}{the number of desired columns in the projection matrix.}

\item{lambda}{passed to the \code{\link[stats]{rpois}} function for generation of non-zero elements in the random matrix.}

\item{catMap}{a list specifying specifies which one-of-K encoded columns in X correspond to the same categorical feature.}

\item{...}{used to handle superfluous arguments passed in using paramList.}
}
\value{
A random matrix to use in running \code{\link{RerF}}.
}
\description{
Samples a binary projection matrix where sparsity is distributed
\eqn{Poisson(\lambda)}.
}
\examples{

p <- 8
d <- 8
lambda <- 0.5
paramList <- list(p = p, d = d, lambda = lambda)
set.seed(8)
(a <- do.call(RandMatPoisson, paramList))
}
