% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandMat.R
\name{RandMatImageControl}
\alias{RandMatImageControl}
\title{Create a Random Matrix: image-control}
\usage{
RandMatImageControl(p, d, ih, iw, pwMin, pwMax, ...)
}
\arguments{
\item{p}{the number of dimensions.}

\item{d}{the number of desired columns in the projection matrix.}

\item{ih}{the height (px) of the image.}

\item{iw}{the width (px) of the image.}

\item{pwMin}{the minimum patch size to sample.}

\item{pwMax}{the maximum patch size to sample.}

\item{...}{used to handle superfluous arguments passed in using paramList.}
}
\value{
A random matrix to use in running \code{\link{RerF}}.
}
\description{
Create a Random Matrix: image-control
}
\examples{

p <- 28^2
d <- 8
ih <- iw <- 28
pwMin <- 3
pwMax <- 6
paramList <- list(p = p, d = d, ih = ih, iw = iw, pwMin = pwMin, pwMax = pwMax)
set.seed(8)
(a <- do.call(RandMatImageControl, paramList))
}
