% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_setup.R
\name{cache_setup}
\alias{cache_setup}
\alias{cache_info}
\title{Setup cache path}
\usage{
cache_setup(path_suffix = NULL, temp_dir = FALSE)

cache_info()
}
\arguments{
\item{path_suffix}{(character) the path suffix to use for storing cached
files, appended to user cache dir.}

\item{temp_dir}{(logical) if \code{TRUE} use a randomly assigned
\code{tempdir} (and \code{path_suffix} is ignored), if \code{FALSE}, you
can use \code{path_suffix}.}
}
\value{
the full cache path, a directory (character)
}
\description{
Setup cache path
}
\details{
Looks first if the user has set a cache path suffix in an
env var or R option. If not found, proceeds to use a temp directory
if not in interactive mode, but if interactive, asks user to setup a
default cache location that will work across sessions (but user can say
no, in which case a temp directory will be used, and each package
start will require cache setup again)
}
\examples{
\dontrun{
# default path
cache_setup()

# you can define your own path
cache_setup(path = "foobar")

# set a tempdir - better for programming with to avoid prompt
cache_setup(temp_dir = TRUE)

# cache info
cache_info()
}
}
\seealso{
Other cache: 
\code{\link{cache_delete}()},
\code{\link{cache_details}()},
\code{\link{cache_list}()}
}
\concept{cache}
