% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cache_details.R
\name{cache_details}
\alias{cache_details}
\title{Get details of cached files}
\usage{
cache_details(x, cache_path = "~/.rerddap")
}
\arguments{
\item{x}{File names}

\item{cache_path}{path to cached files}
}
\description{
Get details of cached files
}
\examples{
\dontrun{
# List details for all cached files
cache_details()

# List details for specific files
# cache_details("243b4b41e19444515986ccf9cafbb1e9.nc")
# cache_details("476ea03d8d246d81f2de02bd40524adb.csv")

# For a list or character vector of files
ff <- cache_list()[[1]]
cache_details(ff[1:3])
cache_details(as.list(ff[1:3]))

# List details from output of griddap or tabledap
## tabledap
(table_res <- tabledap('erdCalCOFIfshsiz'))
cache_details(table_res)

## griddap
(grid_res <- griddap('noaa_esrl_027d_0fb5_5d38',
 time = c('2012-01-01','2012-06-12'),
 latitude = c(21, 18),
 longitude = c(-80, -75)
))
cache_details(grid_res)
}
}
\author{
Scott Chamberlain <myrmecocystus@gmail.com>
}
\references{
\url{http://upwell.pfeg.noaa.gov/erddap/index.html}
}
\seealso{
\code{\link{cache_list}}, \code{\link{cache_delete}}
}

