% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{varStandardizedEffectSize}
\alias{varStandardizedEffectSize}
\title{varStandardizedEffectSize}
\usage{
varStandardizedEffectSize(d, A, f, returnVarg = TRUE)
}
\arguments{
\item{d}{An unadjusted standardized effect size}

\item{A}{The squared constant linking t and d i.e. t*sqrt(A)=d}

\item{f}{The degrees of freedom of the t value}

\item{returnVarg}{if set to TRUE return the variance of the small sample size adjusted standardized effect size (g), otherwise returns var(d) where d is the input parameter}
}
\value{
if returnVarg if set to TRUE, return var(g) otherwise var(d)
}
\description{
Function calculates the exact variance of a standardized effect size based on the relationship between t and the standardized effect size, see Morris and DeShon, Combining Effect Size Estimates in Meta-Analysis With Repeated Measures and Independent-Groups Designs, Psychological Methods, 7 (1), pp 105-125.
}
\examples{
d <- 0.5
varStandardizedEffectSize(d, 2 / 20, 38, returnVarg = FALSE)
# [1]  0.1047567
varStandardizedEffectSize(d, 2 / 20, 38, returnVarg = TRUE)
# [1] 0.1090516
}
\author{
Barbara Kitchenham and Lech Madeyski
}
