% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{metaanalyseSmallSampleSizeExperiments}
\alias{metaanalyseSmallSampleSizeExperiments}
\title{metaanalyseSmallSampleSizeExperiments}
\usage{
metaanalyseSmallSampleSizeExperiments(d, f, A)
}
\arguments{
\item{d}{a vector of standardized mean differences for different experiments (not adjusted for small sample size)}

\item{f}{a vector defining the degrees  for each experiment}

\item{A}{a vector defining the relationship between d and its related t value for each experiment}
}
\value{
UnweightedMean The unweighted mean of the small size adjusted standardized mean differences

WeightedMean The weighted mean of the small size adjusted standardized mean differences

VarWeightedMean The variance of the weighted mean
}
\description{
Implements analysis of small sample size experiments based on Hedges and Olkin p128-131.
}
\examples{
d=c(.461,.782,.513,.612,-0.131,-0.018,0.774,0.138,-0.482,0.333,.701,-0.222,
  .399,.538,-0.19,0.833,0.512,0.601,-0.366,.510)
A=c(2/5,2/5,2/7,2/10,2/8,2/10,2/6,2/6,2/4,2/9,2/9,2/7,2/7,2/5,2/5,2/4,2/10,2/8,2/4,2/8)
f=c(8,8,12,18,14,18,10,10,6,16,16,12,12,8,8,6,18,14,6,14)
metaanalyseSmallSampleSizeExperiments(d,f,A)
}
\author{
Barbara Kitchenham and Lech Madeyski
}
