% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{calculatePopulationStatistics}
\alias{calculatePopulationStatistics}
\title{calculatePopulationStatistics}
\usage{
calculatePopulationStatistics(mean, std, type = "n")
}
\arguments{
\item{mean}{The theoretical central location parameter for the distribution specified by the type parameter.}

\item{std}{The theoretical spread parameter for the distribution specified by the type parameter.}

\item{type}{String identifying the distribution, 'n' for normal, 'ln' for lognormal, 'lap' for Laplace, 'g' for Gamm}
}
\value{
dataframe containing the expected standardized effect size, mean, variance,skewness and kurtosis statistics for samples from the specific distribution
}
\description{
This helper function constructs the theoretical effect sizes and distribution statistics four (normal, lognormal, Laplace & gamma) given specific parameter values for the distributions and is used to support the calculation of population statistics for two and four group experiments.
}
\examples{
reproducer:::calculatePopulationStatistics(mean=0, std=1, type='l')
#   RawMean RawVariance RawEffectSize RawSkewness RawKurtosis
#1 1.648721    4.670774      0.762874    6.184877    88.54343
reproducer:::calculatePopulationStatistics(mean=0, std=1, type='n')
#   RawMean RawVariance RawEffectSize RawSkewness RawKurtosis
# 1       0           1             0           0           3
}
\author{
Barbara Kitchenham and Lech Madeyski
}
