% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPaperFunctions.R
\name{ExtractSummaryStatisticsRandomizedExp}
\alias{ExtractSummaryStatisticsRandomizedExp}
\title{ExtractSummaryStatisticsRandomizedExp}
\usage{
ExtractSummaryStatisticsRandomizedExp(lmeRA, N, alpha = 0.05)
}
\arguments{
\item{lmeRA}{The output from the lmer function}

\item{N}{The total number of observations}

\item{alpha}{the probability level to be used when constructing the confidence interval bounds.}
}
\value{
REA.Summary A dataframe holding the number of observations N, the overall mean value as
its standard error reported as by the lmer function, and its confidence interval bounds.
}
\description{
This function extracts data obtained from the lme4 package lmer function. It assumes a simple randomized experiment with each element having one or more repeated measures. It outputs the mean together with its standard error and confidence interval bounds.
}
\examples{
ShortExperimentNames <- c("E1", "E2", "E3", "E4")
FullExperimentNames <- c("EUBAS", "R1UCLM", "R2UCLM", "R3UCLM")
Metrics <- c("Comprehension", "Modification")
Groups <- c("A", "B", "C", "D")
Type <- c(rep("4G", 4))
StudyID <- "S2"
Control <- "SC"
ReshapedData <- ExtractExperimentData(
  KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14TOSEM,
  ExperimentNames = FullExperimentNames, idvar = "ParticipantID", timevar = "Period",
  ConvertToWide = TRUE
)
NewTable <- ConstructLevel1ExperimentRData(
  ReshapedData, StudyID, ShortExperimentNames, Groups,
  Metrics, Type, Control
)
resRe <- lme4::lmer(r ~ (1 | Id), data = NewTable)
summary(resRe)
# Linear mixed model fit by REML ['lmerMod']
# Formula: r ~ (1 | Id)
# REML criterion at convergence: 47.8
# Scaled residuals:
#    Min      1Q  Median      3Q     Max
# -1.4382 -0.9691  0.2190  0.8649  1.4761
#
# Random effects:
#  Groups   Name        Variance Std.Dev.
#   Id       (Intercept) 0.03978  0.1994
#   Residual             0.20974  0.4580
#  Number of obs: 32, groups:  Id, 16
#
#  Fixed effects:
#             Estimate Std. Error t value
#  (Intercept)  0.06175    0.09508   0.649
#  N=length(NewTable$r)
ExtractSummaryStatisticsRandomizedExp(lmeRA = resRe, N = 32, alpha = 0.05)
#      N    Mean      SE LowerBound UpperBound
#   1 32 0.06175 0.09508    -0.1319     0.2554

}
\author{
Barbara Kitchenham and Lech Madeyski
}
