% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{Cliffd.test}
\alias{Cliffd.test}
\title{Cliffd.test}
\usage{
Cliffd.test(x, y, alpha = 0.05, alternative = "two.sided", sigfig = -1)
}
\arguments{
\item{x}{The data from one group}

\item{y}{The data from the alternative group}

\item{alpha}{The significance level of tests which also controls
the values of the confidence interval (default 0.05)}

\item{alternative}{This defines whether a one-sided test or a two-sided test
is required (default "two.sided"). For a one-sided test use parameter values
'greater' or 'less' to define whether the d-value should be greater or
less than zero.}

\item{sigfig}{is the number of significant digits. If sigfig>0 the data in x
and y is truncated to the specified number of significant digits.}
}
\value{
The values of Cliff's d and its standard error, the t-value,
its pvalue and the upper and lower confidence interval.
}
\description{
This function provides single-sided and two-sided tests of Cliff's d
}
\examples{
a=c(1.2,3,2.2,4,2.5,3)
b=c(3,4.2,4,6,7,5.9)
Cliffd.test(a,b,alpha = .05,alternative='two.sided',sigfig = -1)
# A tibble: 1 x 7
#       d sqse.d d.tvalue d.pvalue d.ci.lower d.ci.upper d.sig
#   <dbl>  <dbl>    <dbl>    <dbl>      <dbl>      <dbl> <lgl>
#1 -0.861 0.0202    -42.7 1.20e-12     -0.896     -0.816 TRUE

Cliffd.test(b,a,alpha = .05,alternative='greater',sigfig = -1)
# A tibble: 1 x 7
#      d sqse.d d.tvalue d.pvalue d.ci.lower d.ci.upper d.sig
#  <dbl>  <dbl>    <dbl>    <dbl>      <dbl>      <dbl> <lgl>
#1 0.861 0.0202     42.7 5.99e-13      0.824          1 TRUE

}
\author{
Barbara Kitchenham and Lech Madeyski
}
