% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalysisForFamiliesOfExperimentsSR.R
\name{ExtractMAStatistics}
\alias{ExtractMAStatistics}
\title{ExtractMAStatistics}
\usage{
ExtractMAStatistics(maresults, Nc, Nt, Transform = TRUE, type = "d",
  sig = 4)
}
\arguments{
\item{maresults}{is the output from the rma function.}

\item{Nc}{is the number of participants in the control condition group.}

\item{Nt}{is the number of participants in the treatment condition group.}

\item{Transform}{is a boolean value indicating whether the outcome values need to be transformed back to standardized mean difference ("d" i.e. Hg) or point biserial correlations ("r"). It is defaulted to TRUE. If this parameter is set to FALSE, no transformation will be applied.}

\item{type}{this indicates the type of transformation required - it defaults to "d" which requests transformation from Zr to Hg, using "r" requests transformation from Zr to r.}

\item{sig}{indicates the number of significant digits requested in the output, the default is 4; it rounds the values of mean, pvalue, upper and lower bound to the specified number of significant digits.}
}
\value{
data frame incl. summary statistics from meta-analysis results: overall mean value for the effect sizes, the p-value of the mean, the upper and lower confidence interval bounds (UB and LB), QE which is the heterogeneity test statistic and QEp which the the p-value of the heterogeneity statistic
}
\description{
This function extracts summary statistics from meta-analysis results obtained from the rma function of the metafor R package. If required the function transform back to standardized mean difference (effect size type "d" i.e. Hg) or point biserial correlations (effect size type "r").
Warning: the `ExtractMAStatistics` function works with `metafor` version 2.0-0, but changes to metafor's method of providing access to its individual results may introduce errors into the function.
}
\examples{
ExpData=reproducer::KitchenhamMadeyskiBrereton.ExpData
#Extract the experiment basic statics
S1data=subset(ExpData,ExpData=="S1")
#Use the descriptive data to construct effect size
S1EffectSizes = reproducer::PrepareForMetaAnalysisGtoR(S1data$Mc,
S1data$Mt,S1data$SDc,S1data$SDt,S1data$Nc,S1data$Nt)
# Do a random effect meta-analysis of the transformed r_pbs effect size
S1MA = metafor::rma(S1EffectSizes$zr, S1EffectSizes$vi)
# Extract summary statistics from meta-analysis results and transform back to Hg scale
S1MAStats=reproducer::ExtractMAStatistics(S1MA, sum(S1data$Nc),sum(S1data$Nt), TRUE, "d", 4)
#    mean   pvalue    UB     LB QE  QEp
#1 0.6658 0.002069 1.122 0.2384  4 0.41
}
\author{
Barbara Kitchenham and Lech Madeyski
}
