% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{forestplotMV}
\alias{forestplotMV}
\title{Create a multivariable forest plot using ggplot2}
\usage{
forestplotMV(
  model,
  data,
  conf.level = 0.95,
  orderByRisk = TRUE,
  colours = "default",
  showEst = TRUE,
  rmRef = FALSE,
  digits = getOption("reportRmd.digits", 2),
  logScale = getOption("reportRmd.logScale", TRUE),
  nxTicks = 5,
  showN = TRUE,
  showEvent = TRUE
)
}
\arguments{
\item{model}{an object output from the glm or geeglm function, must be from a logistic
regression}

\item{data}{dataframe containing your data}

\item{conf.level}{controls the width of the confidence interval}

\item{orderByRisk}{logical, should the plot be ordered by risk}

\item{colours}{can specify colours for risks less than, 1 and greater than
1.0. Default is red, black, green}

\item{showEst}{logical, should the risks be displayed on the plot in text}

\item{rmRef}{logical, should the reference levels be removed for the plot?}

\item{digits}{number of digits to use displaying estimates}

\item{logScale}{logical, should OR/RR be shown on log scale, defaults to
TRUE, or reportRmd.logScale if set. See https://doi.org/10.1093/aje/kwr156 for why you may prefer a
linear scale.}

\item{nxTicks}{Number of tick marks supplied to the log_breaks function to
produce}

\item{showN}{Show number of observations per variable and category}

\item{showEvent}{Show number of events per variable and category}
}
\value{
a plot object
}
\description{
This function will send and take log or logistic regression fit from glm or geeglm
from mvsum function, and display the OR or RR for each variable on the appropriate log scale.
}
\examples{
data("pembrolizumab")
glm_fit = glm(orr~change_ctdna_group+sex+age+l_size,
data=pembrolizumab,family = 'binomial')
forestplotMV(glm_fit)
}
\keyword{plot}
