% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_random.R
\name{report_random}
\alias{report_random}
\title{Report random effects and factors}
\usage{
report_random(x, ...)
}
\arguments{
\item{x}{The R object that you want to report (see list of of supported
objects above).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
An object of class \code{\link[=report_random]{report_random()}}.
}
\description{
Reports random effects of mixed models (see list of supported objects in
\code{\link[=report]{report()}}).
}
\examples{
\dontshow{if (requireNamespace("lme4", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Mixed models
library(lme4)
model <- lme4::lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
r <- report_random(model)
r
summary(r)
}
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("rstanarm", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Bayesian models
library(rstanarm)
model <- suppressWarnings(stan_lmer(
  mpg ~ disp + (1 | cyl),
  data = mtcars, refresh = 0, iter = 1000
))
r <- report_random(model)
r
summary(r)
}
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("brms", quietly = TRUE) && packageVersion("rstan") >= "2.26.0") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(brms)
model <- suppressWarnings(brm(mpg ~ disp + (1 | cyl), data = mtcars, refresh = 0, iter = 1000))
r <- report_random(model)
r
summary(r)
}
\dontshow{\}) # examplesIf}
}
