% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joinController.R
\name{executeLeftJoinPlan}
\alias{executeLeftJoinPlan}
\title{Execute an ordered sequence of left joins.}
\usage{
executeLeftJoinPlan(tDesc, columnJoinPlan, ..., checkColumns = FALSE,
  eagerCompute = TRUE, checkColClasses = FALSE, verbose = FALSE,
  tempNameGenerator = makeTempNameGenerator("executeLeftJoinPlan"))
}
\arguments{
\item{tDesc}{description of tables, from \code{\link{tableDesription}} only used to map table names to data.}

\item{columnJoinPlan}{columns to join, from \code{\link{buildJoinPlan}} (and likely altered by user).  Note: no column names must intersect with names of the form \code{table_CLEANEDTABNAME_present}.}

\item{...}{force later arguments to bind by name.}

\item{checkColumns}{logical if TURE confirm column names before starting joins.}

\item{eagerCompute}{logical if TRUE materialize intermediate results with \code{dplyr::compute}.}

\item{checkColClasses}{logical if true check for exact class name matches}

\item{verbose}{logical if TRUE print more.}

\item{tempNameGenerator}{temp name generator produced by replyr::makeTempNameGenerator, used to record dplyr::compute() effects.}
}
\value{
joined table
}
\description{
Execute an ordered sequence of left joins.
}
\examples{


# example data
meas1 <- data.frame(id= c(1,2),
                    weight= c(200, 120),
                    height= c(60, 14))
meas2 <- data.frame(pid= c(2,3),
                    weight= c(105, 110),
                    width= 1)
# get the initial description of table defs
tDesc <- rbind(tableDesription('meas1', meas1),
               tableDesription('meas2', meas2))
# declare keys (and give them consitent names)
tDesc$keys[[1]] <- list(PatientID= 'id')
tDesc$keys[[2]] <- list(PatientID= 'pid')
# build the column join plan
columnJoinPlan <- buildJoinPlan(tDesc)
# decide we don't want the width column
columnJoinPlan$want[columnJoinPlan$resultColumn=='width'] <- FALSE
# double check our plan
if(!is.null(inspectDescrAndJoinPlan(tDesc, columnJoinPlan,
            checkColClasses= TRUE))) {
  stop("bad join plan")
}
# execute the left joins
executeLeftJoinPlan(tDesc, columnJoinPlan,
                    checkColClasses= TRUE,
                    verbose= TRUE)

}
