% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install}
\alias{install}
\title{Install packages}
\usage{
install(
  packages = NULL,
  ...,
  library = NULL,
  type = NULL,
  rebuild = FALSE,
  repos = NULL,
  prompt = interactive(),
  dependencies = NULL,
  project = NULL
)
}
\arguments{
\item{packages}{Either \code{NULL} (the default) to install all packages required
by the project, or a character vector of packages to install. renv
supports a subset of the remotes syntax used for package installation,
e.g:
\itemize{
\item \code{pkg}: install latest version of \code{pkg} from CRAN.
\item \code{pkg@version}: install specified version of \code{pkg} from CRAN.
\item \code{username/repo}: install package from GitHub
\item \code{bioc::pkg}: install \code{pkg} from Bioconductor.
}

See \url{https://remotes.r-lib.org/articles/dependencies.html} and the examples
below for more details.

renv deviates from the remotes spec in one important way: subdirectories
are separated from the main repository specification with a \code{:}, not \code{/}.
So to install from the \code{subdir} subdirectory of GitHub package
\code{username/repo} you'd use \verb{"username/repo:subdir}.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, renv will signal an error.}

\item{library}{The \R library to be used. When \code{NULL}, the active project
library will be used instead.}

\item{type}{The type of package to install ("source" or "binary"). Defaults
to the value of \code{getOption("pkgType")}.}

\item{rebuild}{Force packages to be rebuilt, thereby bypassing any installed
versions of the package available in the cache? This can either be a
boolean (indicating that all installed packages should be rebuilt), or a
vector of package names indicating which packages should be rebuilt.}

\item{repos}{The repositories to use when restoring packages installed
from CRAN or a CRAN-like repository. By default, the repositories recorded
in the lockfile will be, ensuring that (e.g.) CRAN packages are
re-installed from the same CRAN mirror.

Use \code{repos = getOptions(repos)} to override with the repositories set
in the current session, or see the \code{repos.override} option in \link{config} for
an alternate way override.}

\item{prompt}{Boolean; prompt the user before taking any action? For backwards
compatibility, \code{confirm} is accepted as an alias for \code{prompt}.}

\item{dependencies}{A vector of DESCRIPTION field names that should be used
for package dependency resolution. When \code{NULL} (the default), the value
of \code{renv::settings$package.dependency.fields} is used. The aliases
"strong", "most", and "all" are also supported.
See \code{\link[tools:package_dependencies]{tools::package_dependencies()}} for more details.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
A named list of package records which were installed by renv.
}
\description{
Install one or more \R packages, from a variety of remote sources.
\code{install()} uses the same machinery as \code{\link[=restore]{restore()}} for package installation.
In particular, this means that the local cache of package installations is
used when possible. This helps to avoid re-downloading packages that have
already been downloaded before, and re-compiling packages from source when
a binary copy of that package is already available.

See \code{vignette("package-install")} for more details.
}
\section{Project \code{DESCRIPTION} files}{
If your project contains a \code{DESCRIPTION} file, then calling \code{install()}
without any arguments will instruct renv to install the latest versions of
all packages as declared within that \code{DESCRIPTION} file's \code{Depends},
\code{Imports} and \code{LinkingTo} fields; similar to how an \R package might declare
its dependencies.

If you have one or more packages that you'd like to install from a separate
remote source, this can be accomplished by adding a \verb{Remotes:} field to the
\code{DESCRIPTION} file. See \code{vignette("dependencies", package = "devtools")}
for more details. Alternatively, view the vignette online at
\url{https://devtools.r-lib.org/articles/dependencies.html}.

Note that \code{install()} does not use the project's \code{renv.lock} when determining
sources for packages to be installed. If you want to install packages using
the sources declared in the lockfile, consider using \code{restore()} instead.
Otherwise, you can declare the package sources in your \code{DESCRIPTION}'s
\verb{Remotes:} field.
}

\section{Bioconductor}{
Packages from Bioconductor can be installed by using the \verb{bioc::} prefix.
For example,

\if{html}{\out{<div class="sourceCode">}}\preformatted{renv::install("bioc::Biobase")
}\if{html}{\out{</div>}}

will install the latest-available version of Biobase from Bioconductor.

renv depends on BiocManager (or, for older versions of \R, BiocInstaller)
for the installation of packages from Bioconductor. If these packages are
not available, renv will attempt to automatically install them before
fulfilling the installation request.
}

\examples{
\dontrun{

# install the latest version of 'digest'
renv::install("digest")

# install an old version of 'digest' (using archives)
renv::install("digest@0.6.18")

# install 'digest' from GitHub (latest dev. version)
renv::install("eddelbuettel/digest")

# install a package from GitHub, using specific commit
renv::install("eddelbuettel/digest@df55b00bff33e945246eff2586717452e635032f")

# install a package from Bioconductor
# (note: requires the BiocManager package)
renv::install("bioc::Biobase")

# install a package, specifying path explicitly
renv::install("~/path/to/package")

# install packages as declared in the project DESCRIPTION file
renv::install()

}
}
