% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\docType{data}
\name{paths}
\alias{paths}
\title{Path Customization}
\format{An object of class \code{list} of length 3.}
\usage{
paths
}
\description{
Access the paths that \code{renv} uses for global state storage.
}
\details{
By default, \code{renv} collects state into these folders:

\tabular{ll}{
\strong{Platform} \tab \strong{Location} \cr
Linux        \tab \verb{~/.local/share/renv} \cr
macOS        \tab \verb{~/Library/Application Support/renv} \cr
Windows      \tab \verb{\%LOCALAPPDATA\%/renv} \cr
}

If desired, this path can be adjusted by setting the \code{RENV_PATHS_ROOT}
environment variable. This can be useful if you'd like, for example, multiple
users to be able to share a single global cache.

The various state sub-directories can also be individually adjusted, if so
desired (e.g. you'd prefer to keep the cache of package installations on a
separate volume). The various environment variables that can be set are
enumerated below:

\tabular{ll}{
\strong{Environment Variable} \tab \strong{Description} \cr
\code{RENV_PATHS_ROOT}        \tab The root path used for global state storage. \cr
\code{RENV_PATHS_LIBRARY}     \tab The root path containing different \R libraries. \cr
\code{RENV_PATHS_LOCAL}       \tab The path containing local package sources. \cr
\code{RENV_PATHS_SOURCE}      \tab The path containing downloaded package sources. \cr
\code{RENV_PATHS_BINARY}      \tab The path containing downloaded package binaries. \cr
\code{RENV_PATHS_CACHE}       \tab The path containing cached package installations. \cr
\code{RENV_PATHS_RTOOLS}      \tab (Windows only) The path to \href{https://cran.r-project.org/bin/windows/Rtools/}{Rtools}. \cr
\code{RENV_PATHS_EXTSOFT}     \tab (Windows only) The path containing external software needed for compilation of Windows source packages. \cr
}

Note that \code{renv} will append platform-specific and version-specific entries
to the set paths as appropriate. For example, if you have set:\preformatted{Sys.setenv(RENV_PATHS_CACHE = "/mnt/shared/renv/cache")
}

then the directory used for the cache will still depend on the \R version
(e.g. \code{3.5}) and the \code{renv} cache version (e.g. \code{v2}). For example:\preformatted{/mnt/shared/renv/cache/R-3.5/v2
}

This ensures that you can set a single \code{RENV_PATHS_CACHE} environment variable
globally without worry that it may cause collisions or errors if multiple
versions of \R needed to interact with the same cache.

If reproducibility of a project is desired on a particular machine, it is
highly recommended that the \code{renv} cache of installed packages + binary
packages is stored, so that packages can be easily restored in the future --
installation of packages from source can often be arduous.

If you want these settings to persist in your project, it is recommended that
you add these to an appropriate \R startup file. For example, these could be
set in:
\itemize{
\item A project-local \code{.Renviron};
\item The user-level \code{.Renviron};
\item A file at \verb{$(R RHOME)/etc/Renviron.site}.
}

Please see ?\link{Startup} for more details.
}
\section{Local Sources}{


If your project depends on one or \R packages that are not available in any
remote location, you can still provide a locally-available tarball for \code{renv}
to use during restore. By default, these packages should be made available in
the folder as specified by the \code{RENV_PATHS_LOCAL} environment variable. The
package sources should be placed in a file at one of these locations:
\itemize{
\item \verb{$\{RENV_PATHS_LOCAL\}/<package>_<version>.<ext>}
\item \verb{$\{RENV_PATHS_LOCAL\}/<package>/<package>_<version>.<ext>}
\item \verb{<project>/renv/local/<package>_<version>.<ext>}
\item \verb{<project>/renv/local/<package>/<package>_<version>.<ext>}
}

where \verb{.<ext>} is \code{.tar.gz} for source packages, or \code{.tgz} for binaries on
macOS and \code{.zip} for binaries on Windows. During a \code{restore()}, packages
installed from an unknown source will be searched for in this location.
}

\section{Projects}{


In order to determine whether a package can safely be removed from the cache,
\code{renv} needs to know which projects are using packages from the cache. Since
packages may be symlinked from the cache, and symlinks are by nature a one-way
link, projects need to also report that they're using the \code{renv} cache.

To accomplish this, whenever \code{renv} is used with a project, it will record
itself as being used within a file located at:
\itemize{
\item \verb{$\{RENV_PATHS_ROOT\}/projects}
}

This file is list of projects currently using the \code{renv} cache. With this,
\code{renv} can crawl projects registered with \code{renv} and use that to determine if
any packages within the cache are no longer in use, and can be removed.
}

\examples{
# get the path to the project library
path <- renv::paths$library()
}
\keyword{datasets}
