% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment_mountaincar.R
\docType{data}
\name{MountainCar}
\alias{MountainCar}
\alias{MountainCarContinuous,}
\alias{mountain.car}
\alias{MountainCarContinuous}
\title{Mountain Car}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\arguments{
\item{...}{[\code{any}] \cr Arguments passed on to \link{makeEnvironment}.}
}
\description{
The classical mountain car problem for reinforcement learning.
}
\details{
The classical Mountain Car task the action is one of {0, 1, 2},
in the continuous version the action is in [-1, 1].
}
\section{Usage}{

\code{makeEnvironment("MountainCar", ...)} \cr
\code{makeEnvironment("MountainCarContinuous", ...)}
}

\section{Methods}{

\itemize{
\item \code{$step(action)} \cr
Take action in environment.
Returns a list with \code{state}, \code{reward}, \code{done}.
\item \code{$reset()} \cr
Resets the \code{done} flag of the environment and returns an initial state.
Useful when starting a new episode.
\item \code{$visualize()} \cr
Visualizes the environment (if there is a visualization function).
}
}

\examples{
env = makeEnvironment("mountain.car")
env$reset()
env$step(1L)

env = makeEnvironment("mountain.car.continuous")
env$reset()
env$step(0.62)
}
\keyword{datasets}
