% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fpca.R
\name{plot.fpca}
\alias{plot.fpca}
\title{Plot the results of a functional PCA}
\usage{
\method{plot}{fpca}(
  x,
  plot_FPCs = 1:x$npc,
  sd_factor = 2,
  response_function = NULL,
  add_symbols = TRUE,
  subtitle = TRUE,
  xlim = NULL,
  ylim = NULL,
  xlab = "t [registered]",
  ylab = "y",
  ...
)
}
\arguments{
\item{x}{Object of class \code{"fpca"}.}

\item{plot_FPCs}{Optional index vector of the FPCs to be plotted.
Defaults to all FPCs contained in \code{x}.}

\item{sd_factor}{Numeric factor with which the standard deviations of each
FPC's scores are multiplied to display its variation in the plots.
Defaults to 2.}

\item{response_function}{Optional response function to be applied before
plotting the curves. Defaults to \code{NULL}, i.e. the identity function if
\code{x$family} is one of \code{c("gaussian","binomial")} or
\code{exp()} if \code{x$family} is one of \code{c("gamma","poisson")}.}

\item{add_symbols}{Indicator if '+' and '-' symbols should be added to the
plot to highlight the direction of the displayed FPCs. Defaults to TRUE.}

\item{subtitle}{If TRUE (default) the parameter \code{sd_factor}
is displayed in the plot subtitle.}

\item{xlim, ylim}{Optional numeric vectors with limits for the x and y axis.}

\item{xlab, ylab}{Optional titles for the x and y axis.}

\item{...}{Additional arguments passed to \code{\link[ggplot2]{theme}}.}
}
\value{
@return If multiple FPCs are plotted, returns a grid of \code{ggplot}
plots, created with \code{cowplot::plot_grid}. If only one FPC is plotted,
returns a single \code{ggplot} plot.
}
\description{
S3 plot method for class \code{fpca}.
Plot FPCA results by visualizing the variation of the individual FPCs around
the global mean. based on an object created with function
\code{\link{fpca_gauss}}, \code{\link{bfpca}} or \code{\link{gfpca_twoStep}}. \cr \cr
The shares of explained variance are included in the plot titles if
\code{x} contains an element \code{evalues_sum}.
}
\examples{
data(growth_incomplete)

fpca_obj = fpca_gauss(Y = growth_incomplete, npc = 2)
if (requireNamespace("ggplot2", quietly = TRUE) &&
requireNamespace("cowplot", quietly = TRUE)) {
library(ggplot2)
plot(fpca_obj)
}

}
\author{
Alexander Bauer \email{alexander.bauer@stat.uni-muenchen.de}
}
