\name{ffpcplot}
\alias{ffpcplot}
\title{Plot PC-based function-on-function regression terms}
\usage{
  ffpcplot(object, type = c("fpc+surf", "surf", "fpc"),
           pages = 1, se.mult = 2, ticktype = "detailed",
           theta = 30, phi = 30, plot = TRUE, auto.layout = TRUE)
}
\arguments{
  \item{object}{a fitted \code{pffr}-model}

  \item{type}{one of "fpc+surf", "surf" or "fpc": "surf"
  shows a perspective plot of the coefficient surface
  implied by the estimated effect functions of the FPC
  loadings, "fpc" shows three plots: 1) a scree-type plot
  of the estimated eigenvalues of the functional covariate,
  2) the estimated eigenfunctions, and 3) the estimated
  coefficient functions associated with the FPC loadings.
  Defaults to showing both.}

  \item{se.mult}{display estimated coefficient functions
  associated with the FPC loadings with plus/minus this
  number time the estimated standard error. Defaults to 2.}

  \item{pages}{the number of pages over which to spread the
  output. Defaults to 1. (Irrelevant if
  \code{auto.layout=FALSE}.)}

  \item{ticktype}{see \code{\link[graphics]{persp}}.}

  \item{theta}{see \code{\link[graphics]{persp}}.}

  \item{phi}{see \code{\link[graphics]{persp}}.}

  \item{plot}{produce plots or only return plotting data?
  Defaults to \code{TRUE}.}

  \item{auto.layout}{should the the function set a suitable
  layout automatically? Defaults to TRUE}
}
\value{
  primarily produces plots, invisibly returns a list
  containing the data used for the plots.
}
\description{
  Convenience function for graphical summaries of
  \code{ffpc}-terms from a \code{pffr} fit.
}
\examples{
\dontrun{
 #see ?ffpc
}
}
\author{
  Fabian Scheipl
}

