##' The US weekly all-cause mortality and COVID19-associated deaths in 2020
##'
##' The COVID19 mortality data used in the "Functional Data Analysis with R" book
##'
##' @name COVID19
##' @docType data
##' 
##' @usage data(COVID19)
##' 
##' @format A list made up of \describe{
##' \item{US_weekly_mort}{A numeric vector of length 207, which contains the 
##' total number of weekly all-cause deaths in the US from January 14, 2017 to December 26, 2020;}
##' \item{US_weekly_mort_dates}{A vector of dates of length 207, which contains 
##' the weeks corresponding to the US_weekly_mort vector;}
##' \item{US_weekly_mort_CV19}{A numeric vector of length 52, which contains the 
##' total number of weekly COVID 19 deaths in the US from January 4, 2020 to December 26, 2020;}
##' \item{US_weekly_mort_CV19_dates}{A vector of dates of length 52, which contains 
##' the weeks corresponding to the US_weekly_mort_CV19 vector;}
##' \item{US_weekly_excess_mort_2020}{A numeric vector of length 52, which contains 
##' the US weekly excess mortality (total mortality in one week in 2020 minus 
##' total mortality in the corresponding week of 2019) from January 4, 2020 to December 26, 2020;}
##' \item{US_weekly_excess_mort_2020_dates}{A vector dates of length 52, which contains 
##' the weeks corresponding to the US_weekly_excess_mort_2020 vector.;}
##' \item{US_states_names}{A vector of strings containing the names of 52 US states 
##' and territories in alphabetic order. These are the states for which all-cause 
##' and Covid-19 data are available in this data set;}
##' \item{US_states_population}{A numeric vector containing the population of the 
##' 52 states in the vector US_states_names estimated as of July 1, 2020. The 
##' order of the vector US_states_population is the same as that of US_states_names;}
##' \item{States_excess_mortality}{A numeric 52 x 52 dimensional matrix that 
##' contains the weekly US excess mortality in 52 states and territories. Each 
##' row corresponds to one state in the same order as the vector US_states_names. 
##' Each column corresponds to a week in 2020 corresponding to the order in the 
##' vector US_weekly_excess_mort_2020_dates. The (i,j)th entry of the matrix is 
##' the difference in all-cause mortality during the week j of 2020 and 2019 for state i;}
##' \item{States_excess_mortality_per_million}{A numeric 52 x 52 dimensional matrix 
##' that contains the weekly US excess mortality in 52 states and territories 
##' per one million individuals. This is obtained by dividing every row (corresponding 
##' to a state) of States_excess_mortality by the population of that state stored 
##' in US_states_population and multiplying by one million;}
##' \item{States_CV19_mortality}{A numeric 52 x 52 dimensional matrix that contains 
##' the weekly US Covid-19 mortality in 52 states and territories. Each row 
##' corresponds to one state in the same order as the vector US_states_names. Each 
##' column corresponds to a week in 2020 corresponding to the order in the 
##' vector US_weekly_excess_mort_2020_dates;}
##' \item{States_CV19_mortality_per_million}{A numeric 52 x 52 dimensional matrix 
##' that contains the weekly US Covid-19 mortality in 52 states and territories 
##' per one million individuals. This is obtained by dividing every row (corresponding 
##' to a state) of States_CV19_mortality by the population of that state stored 
##' in US_states_population and multiplying by one million.}
##' }
##' @references Crainiceanu, C., Goldsmith, J., Leroux, A., Cui, E. (2023). Functional
##' Data Analysis with R. \emph{Chapman & Hall/CRC Statistics}
NULL
