% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peer.R
\name{smooth.construct.peer.smooth.spec}
\alias{smooth.construct.peer.smooth.spec}
\title{Basis constructor for PEER terms}
\usage{
\method{smooth.construct}{peer.smooth.spec}(object, data, knots)
}
\arguments{
\item{object}{a \code{peer.smooth.spec} object, usually generated by a 
term \code{s(x, bs="peer")}; see Details.}

\item{data}{a list containing the data (including any \code{by} variable)
required by this term, with names corresponding to \code{object$term}
(and \code{object$by}). Only the first element of this list is used.}

\item{knots}{not used, but required by the generic \code{smooth.construct}.}
}
\value{
An object of class \code{"peer.smooth"}. See
  \code{\link{smooth.construct}} for the elements that this object will
  contain.
}
\description{
Smooth basis constructor to define structured penalties (Randolph et al.,
2012) for smooth terms.
}
\details{
The smooth specification object, defined using \code{s()}, should
  contain an \code{xt} element. \code{xt} will be a list that contains
  additional information needed to specify the penalty. The type of penalty
  is indicated by \code{xt$pentype}. There are four types of penalties
  available:
\enumerate{
  \item \code{xt$pentype=="RIDGE"} for a ridge penalty, the default
  \item \code{xt$pentype=="D"} for a difference penalty. The order of the
    difference penalty is specified by the \code{m} argument of
    \code{s()}.
  \item \code{xt$pentype=="DECOMP"} for a decomposition-based penalty,
    \eqn{bP_Q + a(I-P_Q)}, where \eqn{P_Q = Q^t(QQ^t)^{-1}Q}. The \eqn{Q}
    matrix must be specified by \code{xt$Q}, and the scalar \eqn{a} by
    \code{xt$phia}. The number of columns of \code{Q} must be equal to the
    length of the data. Each row represents a basis function where the
    functional predictor is expected to lie, according to prior belief.
  \item \code{xt$pentype=="USER"} for a user-specified penalty matrix
    \eqn{L}, supplied by \code{xt$L}.
}
}
\references{
Randolph, T. W., Harezlak, J, and Feng, Z. (2012). Structured penalties for
functional linear models - partially empirical eigenvectors for regression.
\emph{Electronic Journal of Statistics}, 6, 323-353.
}
\seealso{
\code{\link{peer}}
}
\author{
Madan Gopal Kundu \email{mgkundu@iupui.edu} and Jonathan Gellar
}
