% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_export.R
\name{refdb_export_idtaxa}
\alias{refdb_export_idtaxa}
\title{Export reference database for DECIPHER (IDTAXA)}
\usage{
refdb_export_idtaxa(x, file, taxid = FALSE)
}
\arguments{
\item{x}{a reference database.}

\item{file}{a file path without extension. This will be used to create
a .fasta file and two .txt files.}

\item{taxid}{should the taxid file be generated
(can be very slow with large databases)}
}
\value{
No return value, called for side effects.
}
\description{
Write a reference database in file formats which can be used
to train the \code{IDTAXA} classifier implemented in \code{DECIPHER}.
}
\details{
The functions generates three files.

- A fasta files containing the sequences with their IDs.
This file must be imported as a \code{DNAStringSet}
to be used with \code{DECIPHER}, using eg:\cr
\code{Biostrings::readDNAStringSet("ex_seqs.fasta")}

- A text files containing the sequence taxonomic assignment.
This file must be imported as a character vector
to be used with \code{DECIPHER}, using eg:\cr
\code{readr::read_lines("ex_taxo.txt")}

- A text file ("taxid") containing the taxonomic ranks
associated with each taxon. This is an asterisk delimited file
which must be imported as a dataframe (see LearnTaxa), using eg:\cr
\code{readr::read_delim("ex_ranks.txt",
                   col_names = c('Index', 'Name', 'Parent', 'Level', 'Rank'),
                   delim = "*", quote = "")}

The taxid file can be very slow to write for large datasets.
Therefore it is not generated by default.
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_export_idtaxa(lib, tempfile())

}
