% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_filter.R
\name{refdb_filter_tax_precision}
\alias{refdb_filter_tax_precision}
\title{Filter records based on their taxonomic precision.}
\usage{
refdb_filter_tax_precision(x, min_tax)
}
\arguments{
\item{x}{a reference database.}

\item{min_tax}{minimum taxonomic level
(column name of the reference database).}
}
\value{
A tibble (filtered reference database).
}
\description{
Filter records based on their taxonomic precision.
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_filter_tax_precision(lib, min_tax = "family_name")

}
