% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partisan.R
\name{part_rmd}
\alias{part_rmd}
\title{Calculate Ranked Marginal Deviation}
\usage{
part_rmd(plans, shp, dvote, rvote)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame containing other columns.}

\item{dvote}{Unqouted name of column in \code{shp} with total population.}

\item{rvote}{Unqouted name of column in \code{shp} with group population.}
}
\value{
A numeric vector. Can be shaped into a district-by-plan matrix.
}
\description{
Calculate Ranked Marginal Deviation
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
part_rmd(plans = nh$r_2020, shp = nh, rvote = nrv, dvote = ndv)

# Or many plans:
part_rmd(plans = nh_m[, 3:5], shp = nh, rvote = nrv, dvote = ndv)

}
\references{
Gregory Herschlag, Han Sung Kang, Justin Luo, Christy Vaughn Graves, Sachet Bangia,
Robert Ravier & Jonathan C. Mattingly (2020) Quantifying Gerrymandering in North Carolina,
Statistics and Public Policy, 7:1, 30-38, DOI: 10.1080/2330443X.2020.1796400
}
\concept{partisan}
