% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_constr.R
\name{plot.redist_constr}
\alias{plot.redist_constr}
\title{Visualize constraints}
\usage{
\method{plot}{redist_constr}(x, y, type = "group", xlim = c(0, 1), ...)
}
\arguments{
\item{x}{A [redist_constr] object.}

\item{y}{Ignored.}

\item{type}{What type of constraint to visualize. Currently supports only
`"group"`, for visualizing constraint strength by group share.}

\item{xlim}{Range of group shares to visualize.}

\item{\dots}{additional arguments (ignored)}
}
\value{
A ggplot object
}
\description{
Plots the constraint strength versus some running variable. Currently
supports visualizing the `grp_hinge`, `grp_inv_hinge`, and `grp_pow`
constraints.
}
\examples{
data(iowa)
iowa_map <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.05)
constr <- redist_constr(iowa_map)
constr <- add_constr_grp_hinge(constr, strength = 30,
                               dem_08, tot_08, tgts_group = 0.5)
constr <- add_constr_grp_hinge(constr, strength = -20,
                               dem_08, tot_08, tgts_group = 0.3)
plot(constr)

}
\concept{prepare}
